/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import smile.gap.Chromosome;
import smile.gap.Crossover;
import smile.gap.Fitness;
import smile.math.MathEx;

public class BitString
implements Chromosome<BitString> {
    private final byte[] bits;
    private final double mutationRate;
    private final Crossover crossover;
    private final double crossoverRate;
    private final Fitness<BitString> fitness;
    private double fitnessScore = Double.NaN;

    public BitString(int length, Fitness<BitString> measure) {
        this(length, measure, Crossover.TWO_POINT, 0.9, 0.01);
    }

    public BitString(int length, Fitness<BitString> measure, Crossover crossover, double crossoverRate, double mutationRate) {
        this(BitString.bits(length), measure, crossover, crossoverRate, mutationRate);
    }

    public BitString(byte[] bits, Fitness<BitString> measure) {
        this(bits, measure, Crossover.TWO_POINT, 0.9, 0.01);
    }

    public BitString(byte[] bits, Fitness<BitString> fitness, Crossover crossover, double crossoverRate, double mutationRate) {
        if (crossoverRate < 0.0 || crossoverRate > 1.0) {
            throw new IllegalArgumentException("Invalid crossover rate: " + crossoverRate);
        }
        if (mutationRate < 0.0 || mutationRate > 1.0) {
            throw new IllegalArgumentException("Invalid mutation rate: " + mutationRate);
        }
        this.bits = bits;
        this.fitness = fitness;
        this.crossoverRate = crossoverRate;
        this.mutationRate = mutationRate;
        this.crossover = crossover;
    }

    private static byte[] bits(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Invalid bit string length: " + length);
        }
        byte[] bits = new byte[length];
        for (int i = 0; i < length; ++i) {
            bits[i] = (byte)(MathEx.random() > 0.5 ? 1 : 0);
        }
        return bits;
    }

    public int length() {
        return this.bits.length;
    }

    public byte[] bits() {
        return this.bits;
    }

    @Override
    public int compareTo(Chromosome o) {
        return Double.compare(this.fitnessScore, o.fitness());
    }

    @Override
    public double fitness() {
        if (Double.isNaN(this.fitnessScore)) {
            this.fitnessScore = this.fitness.score(this);
        }
        return this.fitnessScore;
    }

    @Override
    public BitString newInstance() {
        return new BitString(this.bits.length, this.fitness, this.crossover, this.crossoverRate, this.mutationRate);
    }

    public BitString newInstance(byte[] bits) {
        return new BitString(bits, this.fitness, this.crossover, this.crossoverRate, this.mutationRate);
    }

    public BitString[] crossover(BitString mother) {
        if (MathEx.random() < this.crossoverRate) {
            return this.crossover.apply(this, mother);
        }
        return new BitString[]{this, mother};
    }

    @Override
    public void mutate() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (!(MathEx.random() < this.mutationRate)) continue;
            int n = i;
            this.bits[n] = (byte)(this.bits[n] ^ 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.bits) {
            sb.append(b);
        }
        return sb.toString();
    }
}

