/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import smile.data.type.StructField;
import smile.data.vector.AbstractVector;
import smile.math.MathEx;

public abstract class PrimitiveVector
extends AbstractVector {
    public PrimitiveVector(StructField field) {
        super(field);
    }

    public double mean() {
        return this.doubleStream().filter(Double::isFinite).average().orElse(0.0);
    }

    public double stdev() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.stdev(data);
    }

    public double min() {
        return this.doubleStream().filter(Double::isFinite).min().orElse(0.0);
    }

    public double max() {
        return this.doubleStream().filter(Double::isFinite).max().orElse(0.0);
    }

    public double median() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.median(data);
    }

    public double q1() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.q1(data);
    }

    public double q3() {
        double[] data = this.doubleStream().filter(Double::isFinite).toArray();
        return MathEx.q3(data);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isNullAt(int i) {
        return false;
    }

    @Override
    public int getNullCount() {
        return 0;
    }
}

