/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.IntStream;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.NullablePrimitiveVector;
import smile.util.Index;

public class NullableShortVector
extends NullablePrimitiveVector {
    private final short[] vector;

    public NullableShortVector(String name, short[] vector, BitSet nullMask) {
        this(new StructField(name, DataTypes.NullableShortType), vector, nullMask);
    }

    public NullableShortVector(StructField field, short[] vector, BitSet nullMask) {
        if (field.dtype() != DataTypes.NullableShortType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        super(field, nullMask);
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public NullableShortVector withName(String name) {
        return new NullableShortVector(this.field.withName(name), this.vector, this.nullMask);
    }

    @Override
    public IntStream intStream() {
        return this.index().map(i -> this.nullMask.get(i) ? Integer.MIN_VALUE : this.vector[i]);
    }

    @Override
    public void set(int i, Object value) {
        if (value == null) {
            this.nullMask.set(i);
        } else if (value instanceof Number) {
            Number n = (Number)value;
            this.vector[i] = n.shortValue();
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
    }

    @Override
    public NullableShortVector get(Index index) {
        int n = index.size();
        short[] data = new short[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int idx = index.apply(i);
            data[i] = this.vector[idx];
            mask.set(i, this.nullMask.get(idx));
        }
        return new NullableShortVector(this.field, data, mask);
    }

    @Override
    public Short get(int i) {
        return this.nullMask.get(i) ? null : Short.valueOf(this.vector[i]);
    }

    @Override
    public short getShort(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] != 0;
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

