/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.DoubleStream;
import smile.data.measure.CategoricalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.NullablePrimitiveVector;
import smile.math.MathEx;
import smile.util.Index;

public class NullableFloatVector
extends NullablePrimitiveVector {
    private final float[] vector;

    public NullableFloatVector(String name, float[] vector, BitSet nullMask) {
        this(new StructField(name, DataTypes.NullableFloatType), vector, nullMask);
    }

    public NullableFloatVector(StructField field, float[] vector, BitSet nullMask) {
        if (field.dtype() != DataTypes.NullableFloatType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof CategoricalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        super(field, nullMask);
        this.vector = vector;
    }

    public void fillna(float value) {
        for (int i = 0; i < this.vector.length; ++i) {
            if (!Float.isNaN(this.vector[i]) && !Float.isInfinite(this.vector[i])) continue;
            this.vector[i] = value;
        }
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public NullableFloatVector withName(String name) {
        return new NullableFloatVector(this.field.withName(name), this.vector, this.nullMask);
    }

    @Override
    public DoubleStream doubleStream() {
        return this.index().mapToDouble(i -> this.nullMask.get(i) ? Double.NaN : (double)this.vector[i]);
    }

    @Override
    public void set(int i, Object value) {
        if (value == null) {
            this.nullMask.set(i);
        } else if (value instanceof Number) {
            Number n = (Number)value;
            this.vector[i] = n.floatValue();
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
    }

    @Override
    public NullableFloatVector get(Index index) {
        int n = index.size();
        float[] data = new float[n];
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int idx = index.apply(i);
            data[i] = this.vector[idx];
            mask.set(i, this.nullMask.get(idx));
        }
        return new NullableFloatVector(this.field, data, mask);
    }

    @Override
    public Float get(int i) {
        return this.nullMask.get(i) ? null : Float.valueOf(this.vector[i]);
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return MathEx.isZero(this.vector[i]);
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return (int)this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return (long)this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

