/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.stream.IntStream;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.PrimitiveVector;
import smile.util.Index;

public class IntVector
extends PrimitiveVector {
    private final int[] vector;

    public IntVector(String name, int[] vector) {
        this(new StructField(name, DataTypes.IntType), vector);
    }

    public IntVector(StructField field, int[] vector) {
        if (field.dtype() != DataTypes.IntType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        super(field);
        this.vector = vector;
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public IntVector withName(String name) {
        return new IntVector(this.field.withName(name), this.vector);
    }

    @Override
    public IntStream intStream() {
        return Arrays.stream(this.vector);
    }

    @Override
    public void set(int i, Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
        Number n = (Number)value;
        this.vector[i] = n.intValue();
    }

    @Override
    public IntVector get(Index index) {
        int[] data = index.stream().map(i -> this.vector[i]).toArray();
        return new IntVector(this.field, data);
    }

    @Override
    public Integer get(int i) {
        return this.vector[i];
    }

    @Override
    public int getInt(int i) {
        return this.vector[i];
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector[i] != 0;
    }

    @Override
    public char getChar(int i) {
        return (char)this.vector[i];
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.vector[i];
    }

    @Override
    public short getShort(int i) {
        return (short)this.vector[i];
    }

    @Override
    public long getLong(int i) {
        return this.vector[i];
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }
}

