/*
 * Decompiled with CFR 0.152.
 */
package smile.data.type;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.Tuple;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.Property;
import smile.data.type.StructField;
import smile.data.vector.ValueVector;

public record StructType(List<StructField> fields, Map<String, Integer> index) implements DataType
{
    private static final Logger logger = LoggerFactory.getLogger(StructType.class);

    public StructType(List<StructField> fields) {
        this(new ArrayList<StructField>(fields), StructType.name2Index(fields));
    }

    public StructType(StructField ... fields) {
        this(Arrays.asList(fields));
    }

    private static Map<String, Integer> name2Index(List<StructField> fields) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < fields.size(); ++i) {
            if (map.putIfAbsent(fields.get(i).name(), i) == null) continue;
            throw new IllegalArgumentException("Duplicate field name: " + fields.get(i).name());
        }
        return map;
    }

    public static StructType of(ValueVector ... columns) {
        StructField[] fields = new StructField[columns.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = columns[i].field();
        }
        return new StructType(fields);
    }

    public int length() {
        return this.fields.size();
    }

    public StructField field(int i) {
        return this.fields.get(i);
    }

    public StructField field(String name) {
        return this.fields.get(this.indexOf(name));
    }

    public StructField apply(int i) {
        return this.fields.get(i);
    }

    public StructField apply(String name) {
        return this.fields.get(this.indexOf(name));
    }

    public void set(int i, StructField field) {
        this.index.remove(this.fields.get(i).name());
        this.fields.set(i, field);
        this.index.put(field.name(), i);
    }

    public void update(int i, StructField field) {
        this.index.remove(this.fields.get(i).name());
        this.fields.set(i, field);
        this.index.put(field.name(), i);
    }

    public void rename(String name, String newName) {
        Integer idx = this.index.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("Field " + name + " not found");
        }
        this.fields.set(idx, this.fields.get(idx).withName(newName));
        this.index.remove(name);
        this.index.put(newName, idx);
    }

    public void add(StructField field) {
        if (this.index.putIfAbsent(field.name(), this.fields.size()) != null) {
            throw new IllegalArgumentException("Duplicate field name: " + field.name());
        }
        this.fields.add(field);
    }

    public int indexOf(String field) {
        return this.index.get(field);
    }

    public String[] names() {
        return (String[])this.fields.stream().map(StructField::name).toArray(String[]::new);
    }

    public DataType[] dtypes() {
        return (DataType[])this.fields.stream().map(StructField::dtype).toArray(DataType[]::new);
    }

    public Measure[] measures() {
        return (Measure[])this.fields.stream().map(StructField::measure).toArray(Measure[]::new);
    }

    public List<Function<String, Object>> parser() {
        ArrayList<Function<String, Object>> parser = new ArrayList<Function<String, Object>>();
        for (StructField field : this.fields) {
            parser.add(field::valueOf);
        }
        return parser;
    }

    @Override
    public String name() {
        return this.fields.stream().map(field -> String.format("%s: %s", field.name(), field.dtype().name())).collect(Collectors.joining(", ", "Struct(", ")"));
    }

    @Override
    public DataType.ID id() {
        return DataType.ID.Struct;
    }

    @Override
    public String toString() {
        return this.fields.stream().map(field -> {
            Object s = String.format("  %s", field.toString());
            DataType dtype = field.dtype();
            if (dtype.isPrimitive() && !dtype.isNullable()) {
                s = (String)s + " NOT NULL";
            }
            return s;
        }).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }

    @Override
    public String toString(Object o) {
        if (o instanceof Tuple) {
            Tuple t2 = (Tuple)o;
            return IntStream.range(0, this.fields.size()).mapToObj(i -> {
                StructField field = this.fields.get(i);
                String value = field.toString(t2.get(i));
                return String.format("  %s: %s", field.name(), value);
            }).collect(Collectors.joining(",\n", "{\n", "\n}"));
        }
        return o.toString();
    }

    @Override
    public Tuple valueOf(String s) {
        String[] elements = s.substring(1, s.length() - 1).split(",");
        Object[] row = new Object[this.fields.size()];
        for (String element : elements) {
            String[] pair = element.split(":");
            int i = this.index.get(pair[0]);
            row[i] = this.fields.get(i).valueOf(pair[1]);
        }
        return Tuple.of(this, row);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StructType) {
            StructType t2 = (StructType)o;
            return this.fields.equals(t2.fields);
        }
        return false;
    }

    public static StructType of(Class<?> clazz) {
        if (clazz.isRecord()) {
            StructField[] fields = (StructField[])Arrays.stream(clazz.getRecordComponents()).map(StructField::of).toArray(StructField[]::new);
            return new StructType(fields);
        }
        try {
            BeanInfo bean = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = bean.getPropertyDescriptors();
            StructField[] fields = (StructField[])Arrays.stream(props).filter(prop -> !prop.getName().equals("class")).map(StructField::of).toArray(StructField[]::new);
            return new StructType(fields);
        }
        catch (IntrospectionException ex) {
            logger.error("Failed to introspect a bean: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static StructType of(Property[] props) {
        return new StructType(Arrays.stream(props).map(Property::field).toList());
    }

    public static StructType of(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        String dbms = rs.getStatement().getConnection().getMetaData().getDatabaseProductName();
        return StructType.of(meta, dbms);
    }

    public static StructType of(ResultSetMetaData meta, String dbms) throws SQLException {
        int ncol = meta.getColumnCount();
        StructField[] fields = new StructField[ncol];
        for (int i = 1; i <= ncol; ++i) {
            String name = meta.getColumnName(i);
            DataType dtype = DataType.of(JDBCType.valueOf(meta.getColumnType(i)), meta.isNullable(i) == 1, dbms);
            fields[i - 1] = new StructField(name, dtype);
        }
        return new StructType(fields);
    }
}

