/*
 * Decompiled with CFR 0.152.
 */
package smile.data.transform;

import java.util.Map;
import java.util.Objects;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.data.AbstractTuple;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.transform.ColumnTransform;
import smile.data.transform.InvertibleTransform;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.DoubleVector;
import smile.data.vector.ValueVector;
import smile.util.function.Function;

public class InvertibleColumnTransform
extends ColumnTransform
implements InvertibleTransform {
    private final Map<String, Function> inverses;

    public InvertibleColumnTransform(String name, Map<String, Function> transforms, Map<String, Function> inverses) {
        super(name, transforms);
        this.inverses = inverses;
    }

    @Override
    public Tuple invert(final Tuple x) {
        return new AbstractTuple(this, x.schema()){
            final /* synthetic */ InvertibleColumnTransform this$0;
            {
                InvertibleColumnTransform invertibleColumnTransform = this$0;
                Objects.requireNonNull(invertibleColumnTransform);
                this.this$0 = invertibleColumnTransform;
                super(schema);
            }

            @Override
            public Object get(int i) {
                Function inverse = this.this$0.inverses.get(this.schema.field(i).name());
                if (inverse != null) {
                    return inverse.apply(x.getDouble(i));
                }
                return x.get(i);
            }
        };
    }

    @Override
    public DataFrame invert(DataFrame data) {
        StructType schema = data.schema();
        ValueVector[] vectors = new ValueVector[schema.length()];
        IntStream.range(0, schema.length()).forEach(i -> {
            StructField field = schema.field(i);
            Function inverse = this.inverses.get(field.name());
            if (inverse != null) {
                DoubleStream stream = ((Stream)data.stream().parallel()).mapToDouble(t2 -> inverse.apply(t2.getDouble(i)));
                vectors[i] = new DoubleVector(field, stream.toArray());
            } else {
                vectors[i] = data.column(i);
            }
        });
        return new DataFrame(vectors);
    }
}

