/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.IsoFields;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import smile.data.Tuple;
import smile.data.formula.DateFeature;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Date
implements Term {
    private final String name;
    private final DateFeature[] features;

    public Date(String name, DateFeature ... features) {
        this.name = name;
        this.features = features;
    }

    public String toString() {
        return String.format("%s%s", this.name, Arrays.toString((Object[])this.features));
    }

    @Override
    public Set<String> variables() {
        return Collections.singleton(this.name);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        final int index = schema.indexOf(this.name);
        final DataType type = schema.field(this.name).dtype();
        switch (type.id()) {
            case Date: {
                if (!this.hasTimeFeatures(this.features)) break;
                throw new UnsupportedOperationException("Cannot extract time features from a date.");
            }
            case Time: {
                if (!this.hasDateFeatures(this.features)) break;
                throw new UnsupportedOperationException("Cannot extract date features from a time.");
            }
            case DateTime: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The filed %s is not a date/time: %s", this.name, type));
            }
        }
        final NominalScale month = new NominalScale(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"});
        final NominalScale dayOfWeek = new NominalScale(new int[]{1, 2, 3, 4, 5, 6, 7}, new String[]{"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"});
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final DateFeature feature : this.features) {
            features.add(new Feature(){
                final StructField field;
                final /* synthetic */ Date this$0;
                {
                    Date date = this$0;
                    Objects.requireNonNull(date);
                    this.this$0 = date;
                    this.field = new StructField(String.format("%s_%s", new Object[]{this.this$0.name, feature}), DataTypes.IntType, feature == DateFeature.MONTH ? month : (feature == DateFeature.DAY_OF_WEEK ? dayOfWeek : null));
                }

                public String toString() {
                    return this.field.name();
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public int applyAsInt(Tuple o) {
                    Object x = this.apply(o);
                    return x == null ? -1 : (Integer)x;
                }

                @Override
                public Object apply(Tuple o) {
                    Object x = o.get(index);
                    if (x == null) {
                        return null;
                    }
                    WeekFields weekFields = WeekFields.of(Locale.ROOT);
                    return switch (type.id()) {
                        case DataType.ID.Date -> {
                            LocalDate date = (LocalDate)x;
                            switch (feature) {
                                case YEAR: {
                                    yield date.getYear();
                                }
                                case MONTH: {
                                    yield date.getMonthValue();
                                }
                                case WEEK_OF_YEAR: {
                                    yield date.get(weekFields.weekOfYear());
                                }
                                case WEEK_OF_MONTH: {
                                    yield date.get(weekFields.weekOfMonth());
                                }
                                case QUARTER: {
                                    yield date.get(IsoFields.QUARTER_OF_YEAR);
                                }
                                case DAY_OF_YEAR: {
                                    yield date.getDayOfYear();
                                }
                                case DAY_OF_MONTH: {
                                    yield date.getDayOfMonth();
                                }
                                case DAY_OF_WEEK: {
                                    yield date.getDayOfWeek().getValue();
                                }
                            }
                            throw new IllegalStateException("Extract time features from a date.");
                        }
                        case DataType.ID.Time -> {
                            LocalTime time = (LocalTime)x;
                            switch (feature) {
                                case HOUR: {
                                    yield time.getHour();
                                }
                                case MINUTE: {
                                    yield time.getMinute();
                                }
                                case SECOND: {
                                    yield time.getSecond();
                                }
                            }
                            throw new IllegalStateException("Extract date features from a time.");
                        }
                        case DataType.ID.DateTime -> {
                            LocalDateTime dateTime = (LocalDateTime)x;
                            switch (feature) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case YEAR: {
                                    yield dateTime.getYear();
                                }
                                case MONTH: {
                                    yield dateTime.getMonthValue();
                                }
                                case WEEK_OF_YEAR: {
                                    yield dateTime.get(weekFields.weekOfYear());
                                }
                                case WEEK_OF_MONTH: {
                                    yield dateTime.get(weekFields.weekOfMonth());
                                }
                                case QUARTER: {
                                    yield dateTime.get(IsoFields.QUARTER_OF_YEAR);
                                }
                                case DAY_OF_YEAR: {
                                    yield dateTime.getDayOfYear();
                                }
                                case DAY_OF_MONTH: {
                                    yield dateTime.getDayOfMonth();
                                }
                                case DAY_OF_WEEK: {
                                    yield dateTime.getDayOfWeek().getValue();
                                }
                                case HOUR: {
                                    yield dateTime.getHour();
                                }
                                case MINUTE: {
                                    yield dateTime.getMinute();
                                }
                                case SECOND: 
                            }
                            yield dateTime.getSecond();
                        }
                        default -> throw new IllegalStateException("Unsupported data type for date/time features");
                    };
                }
            });
        }
        return features;
    }

    private boolean hasTimeFeatures(DateFeature[] features) {
        for (DateFeature feature : features) {
            switch (feature) {
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasDateFeatures(DateFeature[] features) {
        for (DateFeature feature : features) {
            switch (feature) {
                case YEAR: 
                case MONTH: 
                case WEEK_OF_YEAR: 
                case WEEK_OF_MONTH: 
                case QUARTER: 
                case DAY_OF_YEAR: 
                case DAY_OF_MONTH: 
                case DAY_OF_WEEK: {
                    return true;
                }
            }
        }
        return false;
    }
}

