/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import smile.data.Tuple;
import smile.data.formula.Feature;
import smile.data.formula.Operator;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class Add
extends Operator {
    public Add(Term a, Term b) {
        super("+", a, b);
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        List<Feature> xfeatures = this.x.bind(schema);
        List<Feature> yfeatures = this.y.bind(schema);
        if (xfeatures.size() != yfeatures.size()) {
            throw new IllegalStateException(String.format("The features of %s and %s are of different size: %d != %d", this.x, this.y, xfeatures.size(), yfeatures.size()));
        }
        for (int i = 0; i < xfeatures.size(); ++i) {
            final Feature a = xfeatures.get(i);
            final StructField xfield = a.field();
            DataType xtype = xfield.dtype();
            final Feature b = yfeatures.get(i);
            final StructField yfield = b.field();
            DataType ytype = yfield.dtype();
            if (!(xtype.isInt() || xtype.isLong() || xtype.isDouble() || xtype.isFloat() || ytype.isInt() || ytype.isLong() || ytype.isDouble() || ytype.isFloat())) {
                throw new IllegalStateException(String.format("Invalid expression: %s + %s", xtype, ytype));
            }
            features.add(new Feature(){
                final StructField field;
                final Function<Tuple, Object> lambda;
                {
                    Objects.requireNonNull(this$0);
                    this.field = new StructField(String.format("%s + %s", xfield.name(), yfield.name()), DataType.prompt(xfield.dtype(), yfield.dtype()), null);
                    this.lambda = this.field.dtype().isInt() ? o -> a.applyAsInt((Tuple)o) + b.applyAsInt((Tuple)o) : (this.field.dtype().isLong() ? o -> a.applyAsLong((Tuple)o) + b.applyAsLong((Tuple)o) : (this.field.dtype().isFloat() ? o -> Float.valueOf(a.applyAsFloat((Tuple)o) + b.applyAsFloat((Tuple)o)) : (this.field.dtype().isDouble() ? o -> a.applyAsDouble((Tuple)o) + b.applyAsDouble((Tuple)o) : null)));
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Object apply(Tuple o) {
                    Object x = a.apply(o);
                    Object y = b.apply(o);
                    if (x == null || y == null) {
                        return null;
                    }
                    return this.lambda.apply(o);
                }

                @Override
                public int applyAsInt(Tuple o) {
                    return a.applyAsInt(o) + b.applyAsInt(o);
                }

                @Override
                public long applyAsLong(Tuple o) {
                    return a.applyAsLong(o) + b.applyAsLong(o);
                }

                @Override
                public float applyAsFloat(Tuple o) {
                    return a.applyAsFloat(o) + b.applyAsFloat(o);
                }

                @Override
                public double applyAsDouble(Tuple o) {
                    return a.applyAsDouble(o) + b.applyAsDouble(o);
                }
            });
        }
        return features;
    }
}

