/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.kotlin.decoder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.full.KClassifiers;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.kotlin.entity.SealedClassCanNotBeConstructed;
import org.github.gestalt.config.kotlin.reflect.KTypeCapture;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J<\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/github/gestalt/config/kotlin/decoder/KSealedDecoder;", "Lorg/github/gestalt/config/decoder/Decoder;", "", "<init>", "()V", "priority", "Lorg/github/gestalt/config/decoder/Priority;", "name", "", "canDecode", "", "path", "tags", "Lorg/github/gestalt/config/tag/Tags;", "node", "Lorg/github/gestalt/config/node/ConfigNode;", "klass", "Lorg/github/gestalt/config/reflect/TypeCapture;", "decode", "Lorg/github/gestalt/config/utils/GResultOf;", "decoderContext", "Lorg/github/gestalt/config/decoder/DecoderContext;", "gestalt-kotlin"})
@SourceDebugExtension(value={"SMAP\nKSealedDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KSealedDecoder.kt\norg/github/gestalt/config/kotlin/decoder/KSealedDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1563#2:104\n1634#2,3:105\n*S KotlinDebug\n*F\n+ 1 KSealedDecoder.kt\norg/github/gestalt/config/kotlin/decoder/KSealedDecoder\n*L\n71#1:104\n71#1:105,3\n*E\n"})
public final class KSealedDecoder
implements Decoder<Object> {
    @NotNull
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @NotNull
    public String name() {
        return "kSealed";
    }

    public boolean canDecode(@NotNull String path, @NotNull Tags tags, @Nullable ConfigNode node, @NotNull TypeCapture<?> klass) {
        KClassifier classifier;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        if (klass instanceof KTypeCapture && (classifier = ((KTypeCapture)klass).getKType().getClassifier()) instanceof KClass) {
            return ((KClass)classifier).isSealed();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public GResultOf<Object> decode(@NotNull String path, @NotNull Tags tags, @Nullable ConfigNode node, @NotNull TypeCapture<?> klass, @NotNull DecoderContext decoderContext) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)decoderContext, (String)"decoderContext");
        if (klass instanceof KTypeCapture) {
            KClassifier classifier = ((KTypeCapture)klass).getKType().getClassifier();
            DecoderService decoderService = decoderContext.getDecoderService();
            if (classifier instanceof KClass && ((KClass)classifier).isSealed()) {
                List candidates = ((KClass)classifier).getSealedSubclasses();
                if (candidates.isEmpty()) {
                    GResultOf gResultOf = GResultOf.errors((ValidationError)((ValidationError)new ValidationError.NoPermittedClassesInSealedClass(((KTypeCapture)klass).getName(), path)));
                    Intrinsics.checkNotNullExpressionValue((Object)gResultOf, (String)"errors(...)");
                    return gResultOf;
                }
                GResultOf best = null;
                int bestScore = Integer.MAX_VALUE;
                for (KClass cand : candidates) {
                    void $this$mapTo$iv$iv;
                    GResultOf gResultOf = decoderService.decodeNode(path, tags, node, (TypeCapture)KTypeCapture.Companion.of(KClassifiers.createType$default((KClassifier)((KClassifier)cand), null, (boolean)false, null, (int)7, null)), decoderContext);
                    Intrinsics.checkNotNull((Object)gResultOf, (String)"null cannot be cast to non-null type org.github.gestalt.config.utils.GResultOf<kotlin.Any>");
                    GResultOf candidateDecoded = gResultOf;
                    if (!candidateDecoded.hasResults() && bestScore < Integer.MAX_VALUE) {
                        best = candidateDecoded;
                        continue;
                    }
                    if (!candidateDecoded.hasResults()) continue;
                    List list = candidateDecoded.getErrors();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        int n;
                        void err;
                        ValidationError validationError = (ValidationError)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        ValidationLevel validationLevel = err.level();
                        switch (validationLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[validationLevel.ordinal()]) {
                            case 1: {
                                n = 5;
                                break;
                            }
                            case 2: {
                                n = 4;
                                break;
                            }
                            case 3: {
                                n = 3;
                                break;
                            }
                            case 4: {
                                n = 2;
                                break;
                            }
                            case 5: {
                                n = 1;
                                break;
                            }
                            default: {
                                n = 0;
                            }
                        }
                        collection.add(n);
                    }
                    int errorScore = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
                    int fieldCount = 0;
                    for (Class<?> currentClass = candidateDecoded.results().getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                        fieldCount += currentClass.getDeclaredFields().length;
                    }
                    ConfigNode configNode = node;
                    int score = errorScore + Math.abs((configNode != null ? configNode.size() : 0) - fieldCount) * 2;
                    if (score >= bestScore) continue;
                    best = candidateDecoded;
                    bestScore = score;
                }
                GResultOf gResultOf = best;
                if (gResultOf == null) {
                    GResultOf gResultOf2 = GResultOf.errors((ValidationError)((ValidationError)new ValidationError.NoPermittedClassesInSealedClass(((KTypeCapture)klass).getName(), path)));
                    gResultOf = gResultOf2;
                    Intrinsics.checkNotNullExpressionValue((Object)gResultOf2, (String)"errors(...)");
                }
                return gResultOf;
            }
        }
        String string = klass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        GResultOf gResultOf = GResultOf.errors((ValidationError)new SealedClassCanNotBeConstructed(string, path));
        Intrinsics.checkNotNullExpressionValue((Object)gResultOf, (String)"errors(...)");
        return gResultOf;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationLevel.values().length];
            try {
                nArray[ValidationLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationLevel.MISSING_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationLevel.MISSING_OPTIONAL_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationLevel.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationLevel.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

