/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.kotlin.decoder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.kotlin.entity.DataClassCanNotBeConstructed;
import org.github.gestalt.config.kotlin.entity.DataClassHasNoConstructor;
import org.github.gestalt.config.kotlin.entity.DataClassMissingRequiredMember;
import org.github.gestalt.config.kotlin.reflect.KTypeCapture;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J:\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/github/gestalt/config/kotlin/decoder/DataClassDecoder;", "Lorg/github/gestalt/config/decoder/Decoder;", "", "<init>", "()V", "name", "", "priority", "Lorg/github/gestalt/config/decoder/Priority;", "canDecode", "", "path", "tags", "Lorg/github/gestalt/config/tag/Tags;", "configNode", "Lorg/github/gestalt/config/node/ConfigNode;", "klass", "Lorg/github/gestalt/config/reflect/TypeCapture;", "decode", "Lorg/github/gestalt/config/utils/GResultOf;", "node", "type", "decoderContext", "Lorg/github/gestalt/config/decoder/DecoderContext;", "ResultsAndValid", "gestalt-kotlin"})
@SourceDebugExtension(value={"SMAP\nDataClassDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassDecoder.kt\norg/github/gestalt/config/kotlin/decoder/DataClassDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,189:1\n1285#2,2:190\n1299#2,2:192\n295#2,2:194\n1302#2:196\n1252#2,4:206\n504#3,7:197\n463#3:204\n413#3:205\n*S KotlinDebug\n*F\n+ 1 DataClassDecoder.kt\norg/github/gestalt/config/kotlin/decoder/DataClassDecoder\n*L\n84#1:190,2\n84#1:192,2\n86#1:194,2\n84#1:196\n161#1:206,4\n160#1:197,7\n161#1:204\n161#1:205\n*E\n"})
public final class DataClassDecoder
implements Decoder<Object> {
    @NotNull
    public String name() {
        return "DataClass";
    }

    @NotNull
    public Priority priority() {
        return Priority.MEDIUM;
    }

    public boolean canDecode(@NotNull String path, @NotNull Tags tags, @Nullable ConfigNode configNode, @NotNull TypeCapture<?> klass) {
        KClassifier classifier;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        if (klass instanceof KTypeCapture && (classifier = ((KTypeCapture)klass).getKType().getClassifier()) instanceof KClass) {
            return ((KClass)classifier).isData();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public GResultOf<Object> decode(@NotNull String path, @NotNull Tags tags, @NotNull ConfigNode node, @NotNull TypeCapture<?> type, @NotNull DecoderContext decoderContext) {
        KClassifier classifier;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)decoderContext, (String)"decoderContext");
        if (!(node instanceof MapNode)) {
            GResultOf gResultOf = GResultOf.errors((ValidationError)((ValidationError)new ValidationError.DecodingExpectedMapNodeType(path, node)));
            Intrinsics.checkNotNullExpressionValue((Object)gResultOf, (String)"errors(...)");
            return gResultOf;
        }
        DecoderService decoderService = decoderContext.getDecoderService();
        if (type instanceof KTypeCapture && (classifier = ((KTypeCapture)type).getKType().getClassifier()) instanceof KClass && ((KClass)classifier).isData()) {
            Iterable iterable;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map $this$filterValues$iv;
            Object object;
            Object configNode;
            Object paramName;
            Map map;
            Object object2;
            Map $this$associateWith$iv;
            if (((KClass)classifier).getConstructors().isEmpty()) {
                String string = ((KClass)classifier).getSimpleName();
                if (string == null) {
                    string = "";
                }
                GResultOf gResultOf = GResultOf.errors((ValidationError)new DataClassHasNoConstructor(path, string));
                Intrinsics.checkNotNullExpressionValue((Object)gResultOf, (String)"errors(...)");
                return gResultOf;
            }
            KFunction constructor = (KFunction)CollectionsKt.first((Iterable)((KClass)classifier).getConstructors());
            List errors = new ArrayList();
            List missingMembers = new ArrayList();
            Iterable iterable2 = constructor.getParameters();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
            Iterator $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            Iterator iterator = $this$associateWithTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                KProperty1 props;
                Object object3;
                Config configAnnotation;
                Object object4;
                Object v4;
                void it;
                block35: {
                    Object element$iv$iv = iterator.next();
                    KParameter kParameter = (KParameter)element$iv$iv;
                    object2 = element$iv$iv;
                    map = result$iv;
                    boolean bl = false;
                    paramName = null;
                    String string = it.getName();
                    if (string == null) {
                        string = "";
                    }
                    paramName = string;
                    Iterable $this$firstOrNull$iv = KClasses.getDeclaredMemberProperties((KClass)((KClass)classifier));
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KProperty1 it2 = (KProperty1)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)paramName)) continue;
                        v4 = element$iv;
                        break block35;
                    }
                    v4 = null;
                }
                boolean bl = (object4 = (configAnnotation = (object3 = (props = (KProperty1)v4)) != null && (object3 = ReflectJvmMapping.getJavaField((KProperty)((KProperty)object3))) != null ? ((Field)object3).getAnnotation(Config.class) : null)) != null && (object4 = object4.path()) != null ? ((CharSequence)object4).length() > 0 : false;
                if (bl) {
                    paramName = configAnnotation.path();
                }
                String nextPath = PathUtil.pathForKey((SentenceLexer)decoderContext.getDefaultLexer(), (String)path, (String)paramName);
                configNode = decoderService.getNextNode(nextPath, (String)paramName, node);
                List list = configNode.getErrorsNotLevel(ValidationLevel.MISSING_VALUE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrorsNotLevel(...)");
                errors.addAll(list);
                Object results = null;
                boolean resultValid = false;
                if (configNode.hasResults()) {
                    GResultOf parameter = decoderService.decodeNode(nextPath, tags, (ConfigNode)configNode.results(), (TypeCapture)KTypeCapture.Companion.of(it.getType()), decoderContext);
                    List list2 = parameter.getErrors();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getErrors(...)");
                    errors.addAll(list2);
                    if (parameter.hasResults()) {
                        resultValid = true;
                        results = parameter.results();
                    } else {
                        String string = it.getName();
                        if (string == null) {
                            string = "null";
                        }
                        missingMembers.add(string);
                    }
                } else {
                    Object object5 = configAnnotation;
                    boolean bl3 = object5 != null && (object5 = object5.defaultVal()) != null ? !StringsKt.isBlank((CharSequence)((CharSequence)object5)) : false;
                    if (bl3) {
                        boolean bl4;
                        GResultOf defaultGResultOf;
                        Config config = configAnnotation;
                        Intrinsics.checkNotNullExpressionValue((Object)decoderService.decodeNode(nextPath, tags, (ConfigNode)new LeafNode(config != null ? config.defaultVal() : null), (TypeCapture)KTypeCapture.Companion.of(it.getType()), decoderContext), (String)"decodeNode(...)");
                        if (defaultGResultOf.hasErrors()) {
                            List list3 = defaultGResultOf.getErrors();
                            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getErrors(...)");
                            errors.addAll(list3);
                        }
                        if (defaultGResultOf.hasResults()) {
                            resultValid = true;
                            results = defaultGResultOf.results();
                            bl4 = errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), ((KTypeCapture)type).getRawType().getSimpleName(), decoderContext));
                        } else {
                            String string = it.getName();
                            if (string == null) {
                                string = "null";
                            }
                            bl4 = missingMembers.add(string);
                        }
                    } else if (it.getType().isMarkedNullable()) {
                        resultValid = true;
                        errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), ((KTypeCapture)type).getRawType().getSimpleName(), decoderContext));
                    } else if (!it.isOptional()) {
                        String string = it.getName();
                        if (string == null) {
                            string = "null";
                        }
                        missingMembers.add(string);
                    } else if (it.isOptional()) {
                        errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), ((KTypeCapture)type).getRawType().getSimpleName(), decoderContext));
                    }
                }
                object = new ResultsAndValid(results, resultValid);
                map.put(object2, object);
            }
            $this$associateWith$iv = result$iv;
            boolean $i$f$filterValues = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                ResultsAndValid it = (ResultsAndValid)entry$iv.getValue();
                boolean bl = false;
                if (!it.getValid()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$mapValues = false;
            result$iv = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                paramName = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                configNode = (Map.Entry)element$iv$iv$iv;
                object2 = it$iv$iv.getKey();
                map = map2;
                boolean bl5 = false;
                object = ((ResultsAndValid)it.getValue()).getResults();
                map.put(object2, object);
            }
            Map parameters = destination$iv$iv;
            if (!((Collection)missingMembers).isEmpty()) {
                String string = ((KClass)classifier).getSimpleName();
                if (string == null) {
                    string = "";
                }
                errors.add(new DataClassMissingRequiredMember(path, string, missingMembers));
                iterable2 = GResultOf.errors((List)errors);
                Intrinsics.checkNotNull((Object)iterable2);
                iterable = iterable2;
            } else if (!parameters.isEmpty()) {
                iterable2 = GResultOf.resultOf((Object)constructor.callBy(parameters), (List)errors);
                Intrinsics.checkNotNull((Object)iterable2);
                iterable = iterable2;
            } else {
                GResultOf gResultOf;
                try {
                    gResultOf = GResultOf.resultOf((Object)KClasses.createInstance((KClass)((KClass)classifier)), (List)errors);
                }
                catch (IllegalArgumentException e) {
                    String string = ((KClass)classifier).getSimpleName();
                    if (string == null) {
                        string = "";
                    }
                    errors.add(new DataClassCanNotBeConstructed(path, string));
                    gResultOf = GResultOf.errors((List)errors);
                }
                iterable2 = gResultOf;
                Intrinsics.checkNotNull((Object)iterable2);
                iterable = iterable2;
            }
            return iterable;
        }
        String string = type.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        GResultOf gResultOf = GResultOf.errors((ValidationError)new DataClassCanNotBeConstructed(path, string));
        Intrinsics.checkNotNullExpressionValue((Object)gResultOf, (String)"errors(...)");
        return gResultOf;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/github/gestalt/config/kotlin/decoder/DataClassDecoder$ResultsAndValid;", "", "results", "valid", "", "<init>", "(Ljava/lang/Object;Z)V", "getResults", "()Ljava/lang/Object;", "getValid", "()Z", "setValid", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "gestalt-kotlin"})
    public static final class ResultsAndValid {
        @Nullable
        private final Object results;
        private boolean valid;

        public ResultsAndValid(@Nullable Object results, boolean valid) {
            this.results = results;
            this.valid = valid;
        }

        @Nullable
        public final Object getResults() {
            return this.results;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Nullable
        public final Object component1() {
            return this.results;
        }

        public final boolean component2() {
            return this.valid;
        }

        @NotNull
        public final ResultsAndValid copy(@Nullable Object results, boolean valid) {
            return new ResultsAndValid(results, valid);
        }

        public static /* synthetic */ ResultsAndValid copy$default(ResultsAndValid resultsAndValid, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = resultsAndValid.results;
            }
            if ((n & 2) != 0) {
                bl = resultsAndValid.valid;
            }
            return resultsAndValid.copy(object, bl);
        }

        @NotNull
        public String toString() {
            return "ResultsAndValid(results=" + this.results + ", valid=" + this.valid + ")";
        }

        public int hashCode() {
            int result = this.results == null ? 0 : this.results.hashCode();
            result = result * 31 + Boolean.hashCode(this.valid);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResultsAndValid)) {
                return false;
            }
            ResultsAndValid resultsAndValid = (ResultsAndValid)other;
            if (!Intrinsics.areEqual((Object)this.results, (Object)resultsAndValid.results)) {
                return false;
            }
            return this.valid == resultsAndValid.valid;
        }
    }
}

