/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.kotlin.decoder;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.kotlin.reflect.KTypeCapture;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/github/gestalt/config/kotlin/decoder/DoubleDecoder;", "Lorg/github/gestalt/config/decoder/LeafDecoder;", "", "<init>", "()V", "name", "", "priority", "Lorg/github/gestalt/config/decoder/Priority;", "canDecode", "", "path", "tags", "Lorg/github/gestalt/config/tag/Tags;", "configNode", "Lorg/github/gestalt/config/node/ConfigNode;", "klass", "Lorg/github/gestalt/config/reflect/TypeCapture;", "leafDecode", "Lorg/github/gestalt/config/utils/GResultOf;", "node", "decoderContext", "Lorg/github/gestalt/config/decoder/DecoderContext;", "gestalt-kotlin"})
public final class DoubleDecoder
extends LeafDecoder<Double> {
    @NotNull
    public String name() {
        return "kDouble";
    }

    @NotNull
    public Priority priority() {
        return Priority.HIGH;
    }

    public boolean canDecode(@NotNull String path, @NotNull Tags tags, @Nullable ConfigNode configNode, @NotNull TypeCapture<?> klass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return klass instanceof KTypeCapture ? ((KTypeCapture)klass).isAssignableFrom(Reflection.getOrCreateKotlinClass(Double.TYPE)) : false;
    }

    @NotNull
    protected GResultOf<Double> leafDecode(@Nullable String path, @NotNull ConfigNode node, @NotNull DecoderContext decoderContext) {
        GResultOf gResultOf;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)decoderContext, (String)"decoderContext");
        GResultOf results = null;
        String value = node.getValue().orElse("");
        if (StringUtils.isReal((String)value)) {
            GResultOf gResultOf2;
            try {
                Intrinsics.checkNotNull((Object)value);
                double longVal = Double.parseDouble(value);
                gResultOf2 = GResultOf.result((Object)longVal);
            }
            catch (NumberFormatException e) {
                gResultOf2 = GResultOf.errors((ValidationError)((ValidationError)new ValidationError.DecodingNumberFormatException(path, node, this.name(), decoderContext)));
            }
            gResultOf = gResultOf2;
        } else {
            gResultOf = GResultOf.errors((ValidationError)((ValidationError)new ValidationError.DecodingNumberParsing(path, node, this.name())));
        }
        GResultOf gResultOf3 = gResultOf;
        Intrinsics.checkNotNull((Object)gResultOf3);
        results = gResultOf3;
        return results;
    }
}

