/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import java.util.Arrays;
import java.util.List;

public class Testing {
    private static String createLink(String url, String text) {
        String ESC_CHAR = "\u001b";
        String ST = "\u001b\\";
        String HYPERLINK_CMD = "]8;;";
        String OSC8_START = ESC_CHAR + HYPERLINK_CMD + url + ST;
        String OSC8_END = ESC_CHAR + HYPERLINK_CMD + ST;
        return OSC8_START + text + OSC8_END;
    }

    public static void main(String[] args) {
        List<Planet> planets = Arrays.asList(new Planet(1, "Mercury", 0.382, 0.06, "minimal"), new Planet(2, "Venus", 0.949, 0.82, "Carbon dioxide, Nitrogen"), new Planet(3, "Earth", 1.0, 1.0, "Nitrogen, Oxygen, Argon"), new Planet(4, "Mars", 0.532, 0.11, "Carbon dioxide, Nitrogen, Argon"));
        System.out.println(AsciiTable.builder().data(planets, Arrays.asList(new Column().with(planet -> Integer.toString(((Planet)planet).num)), new Column().minWidth(10).with(planet -> ((Planet)planet).name), new Column().with(planet -> String.format("%.03f", ((Planet)planet).diameter)), new Column().with(planet -> String.format("%.02f", ((Planet)planet).mass)), new Column().maxWidth(12).with(planet -> ((Planet)planet).atmosphere))).maxTableWidth(50).asString());
    }

    private static class Planet {
        private final int num;
        private final String name;
        private final double diameter;
        private final double mass;
        private final String atmosphere;

        private Planet(int num, String name, double diameter, double mass, String atmosphere) {
            this.num = num;
            this.name = name;
            this.diameter = diameter;
            this.mass = mass;
            this.atmosphere = atmosphere;
        }
    }

    private static class IdAndDesc {
        private final String id;
        private final String description;

        private IdAndDesc(String id, String description) {
            this.id = id;
            this.description = description;
        }
    }
}

