/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys.paramsparser;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationParamsException;
import java.util.EnumSet;
import java.util.List;

public final class ExpirationExtraParam {
    private int index = 2;
    private final EnumSet<Options> options = EnumSet.noneOf(Options.class);

    public ExpirationExtraParam(List<Slice> params, boolean expectExtra) throws ExpirationParamsException {
        while (this.index < params.size()) {
            Options value2;
            block5: {
                String opt = params.get(this.index).toString();
                for (Options value2 : Options.values()) {
                    if (!value2.toString().equalsIgnoreCase(opt)) {
                        continue;
                    }
                    break block5;
                }
                if (expectExtra) break;
                throw new ExpirationParamsException("ERR Unsupported option " + opt);
            }
            this.options.add(value2);
            ++this.index;
        }
        if (this.options.contains((Object)Options.NX) && this.options.size() > 1) {
            throw new ExpirationParamsException("ERR NX and XX, GT or LT options at the same time are not compatible");
        }
        if (this.options.contains((Object)Options.GT) && this.options.contains((Object)Options.LT)) {
            throw new ExpirationParamsException("ERR GT and LT options at the same time are not compatible");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean checkTiming(Long oldTTL, long newTTL) {
        if (oldTTL == null || oldTTL < 0L) {
            oldTTL = Long.MAX_VALUE;
        }
        if (this.options.contains((Object)Options.NX) && oldTTL != Long.MAX_VALUE) {
            return false;
        }
        if (this.options.contains((Object)Options.XX) && oldTTL == Long.MAX_VALUE) {
            return false;
        }
        if (this.options.contains((Object)Options.LT) && newTTL >= oldTTL) {
            return false;
        }
        return !this.options.contains((Object)Options.GT) || newTTL > oldTTL;
    }

    private static enum Options {
        XX,
        NX,
        LT,
        GT;

    }
}

