/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMString;
import com.github.fppt.jedismock.exception.DeserializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class Slice
implements Comparable<Slice>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Slice emptySlice = new Slice(new byte[0]);
    private final byte[] storedData;

    private Slice(byte[] storedData) {
        if (storedData == null) {
            throw new NullPointerException("Null data");
        }
        this.storedData = storedData;
    }

    public static Slice create(byte[] data) {
        return new Slice(data);
    }

    public static Slice create(String data) {
        return Slice.create((byte[])data.getBytes().clone());
    }

    public static Slice empty() {
        return emptySlice;
    }

    public byte[] data() {
        return Arrays.copyOf(this.storedData, this.storedData.length);
    }

    public int length() {
        return this.data().length;
    }

    public String toString() {
        return new String(this.data());
    }

    public boolean equals(Object b) {
        return b instanceof Slice && Arrays.equals(this.data(), ((Slice)b).data());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data());
    }

    @Override
    public int compareTo(Slice b) {
        int len1 = this.data().length;
        int len2 = b.data().length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte b2;
            byte b1 = this.data()[k];
            if (b1 == (b2 = b.data()[k])) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public RMDataStructure extract() {
        if (this.storedData.length > 2 && this.storedData[0] == -84 && this.storedData[1] == -19) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.storedData));
                Object value = objectInputStream.readObject();
                if (value instanceof RMDataStructure) {
                    return (RMDataStructure)value;
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new DeserializationException("problems with deserialization");
            }
        }
        return RMString.create(this.data());
    }
}

