/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;

public final class ObjectSchemaDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new ObjectSchemaDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private ObjectSchemaDigester() {
        super("", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("hasAdditional", schema.path("additionalProperties").isObject());
        ArrayNode node = FACTORY.arrayNode();
        ret.put("properties", (JsonNode)node);
        HashSet set = Sets.newHashSet((Iterator)schema.path("properties").fieldNames());
        for (String field : Ordering.natural().sortedCopy((Iterable)set)) {
            node.add(field);
        }
        node = FACTORY.arrayNode();
        ret.put("patternProperties", (JsonNode)node);
        set = Sets.newHashSet((Iterator)schema.path("patternProperties").fieldNames());
        for (String field : Ordering.natural().sortedCopy((Iterable)set)) {
            node.add(field);
        }
        return ret;
    }
}

