/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ListProcessingReport;
import com.github.fge.jsonschema.report.LogLevel;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class NotValidator
extends AbstractKeywordValidator {
    private static final JsonPointer PTR = JsonPointer.of((Object)"not", (Object[])new Object[0]);

    public NotValidator(JsonNode digest) {
        super("not");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
        processor.process((ProcessingReport)subReport, (MessageProvider)data.withSchema(tree.append(PTR)));
        if (subReport.isSuccess()) {
            report.error(this.newMsg(data).message((Object)KeywordValidationMessages.NOT_FAIL));
        }
    }

    @Override
    public String toString() {
        return "must not match subschema";
    }
}

