/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.RefSanityChecks;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import com.github.fge.jsonschema.library.DraftV3Library;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.ConfigurationMessages;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class ValidationConfigurationBuilder
implements Thawed<ValidationConfiguration> {
    private static final Map<SchemaVersion, Library> DEFAULT_LIBRARIES = Maps.newEnumMap(SchemaVersion.class);
    final Map<JsonRef, Library> libraries;
    Library defaultLibrary = DEFAULT_LIBRARIES.get(SchemaVersion.DRAFTV4);
    boolean useFormat = true;

    ValidationConfigurationBuilder() {
        this.libraries = Maps.newHashMap();
        for (Map.Entry<SchemaVersion, Library> entry : DEFAULT_LIBRARIES.entrySet()) {
            JsonRef ref = JsonRef.fromURI((URI)entry.getKey().getLocation());
            Library library = entry.getValue();
            this.libraries.put(ref, library);
        }
    }

    ValidationConfigurationBuilder(ValidationConfiguration cfg) {
        this.libraries = Maps.newHashMap(cfg.libraries);
        this.defaultLibrary = cfg.defaultLibrary;
        this.useFormat = cfg.useFormat;
    }

    public ValidationConfigurationBuilder addLibrary(String uri, Library library) {
        JsonRef ref = RefSanityChecks.absoluteRef((String)uri);
        if (library == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ConfigurationMessages.NULL_LIBRARY));
        }
        if (this.libraries.containsKey(ref)) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ConfigurationMessages.DUP_LIBRARY).put("uri", (Object)ref));
        }
        this.libraries.put(ref, library);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultVersion(SchemaVersion version) {
        if (version == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ConfigurationMessages.NULL_VERSION));
        }
        this.defaultLibrary = DEFAULT_LIBRARIES.get(version);
        return this;
    }

    public ValidationConfigurationBuilder setDefaultLibrary(String uri, Library library) {
        this.addLibrary(uri, library);
        this.defaultLibrary = library;
        return this;
    }

    public ValidationConfigurationBuilder setUseFormat(boolean useFormat) {
        this.useFormat = useFormat;
        return this;
    }

    public ValidationConfiguration freeze() {
        return new ValidationConfiguration(this);
    }

    static {
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV3, DraftV3Library.get());
        DEFAULT_LIBRARIES.put(SchemaVersion.DRAFTV4, DraftV4Library.get());
    }
}

