/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.github.fakemongo.async.FongoAsync;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.Server;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.selector.ServerSelector;
import org.bson.Document;

public class MockAsyncMongoClient
extends MongoClientImpl {
    private final FongoAsync fongoAsync;

    public static MockAsyncMongoClient create(FongoAsync fongoAsync) {
        MongoClientSettings settings = MongoClientSettings.builder().codecRegistry(fongoAsync.getFongo().getCodecRegistry()).build();
        MockAsyncMongoClient client = new MockAsyncMongoClient(fongoAsync, settings, new Cluster(){

            public ClusterSettings getSettings() {
                return null;
            }

            public ClusterDescription getDescription() {
                return null;
            }

            public Server selectServer(ServerSelector serverSelector) {
                return null;
            }

            public void selectServerAsync(ServerSelector serverSelector, SingleResultCallback<Server> callback) {
            }

            public void close() {
            }

            public boolean isClosed() {
                return false;
            }
        }, fongoAsync);
        return client;
    }

    public MockAsyncMongoClient(FongoAsync fongoAsync, MongoClientSettings settings, Cluster cluster, AsyncOperationExecutor executor) {
        super(settings, cluster, executor);
        this.fongoAsync = fongoAsync;
    }

    public String toString() {
        return this.fongoAsync.toString();
    }

    public MongoDatabase getDatabase(String name) {
        return this.fongoAsync.getDatabase(name);
    }

    public void close() {
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return null;
    }

    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> tResultClass) {
        return null;
    }
}

