/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.FongoConnection;
import com.github.fakemongo.internal.objenesis.ObjenesisHelper;
import com.github.fakemongo.internal.objenesis.ObjenesisStd;
import com.mongodb.DB;
import com.mongodb.FongoMongoDatabase;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoOptions;
import com.mongodb.ReadConcern;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Connection;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.selector.ServerSelector;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MockMongoClient
extends MongoClient {
    private volatile BufferProvider bufferProvider;
    private Fongo fongo;
    private MongoOptions options;
    private ReadConcern readConcern;
    private MongoClientOptions clientOptions;

    public static MockMongoClient create(Fongo fongo) {
        MongoClientOptions clientOptions;
        MockMongoClient client = ObjenesisHelper.newInstance(MockMongoClient.class);
        client.clientOptions = clientOptions = MongoClientOptions.builder().codecRegistry(fongo.getCodecRegistry()).build();
        client.options = new MongoOptions(clientOptions);
        client.fongo = fongo;
        client.setWriteConcern(clientOptions.getWriteConcern());
        client.setReadPreference(clientOptions.getReadPreference());
        client.readConcern = clientOptions.getReadConcern() == null ? ReadConcern.DEFAULT : clientOptions.getReadConcern();
        return client;
    }

    public String toString() {
        return this.fongo.toString();
    }

    public Collection<DB> getUsedDatabases() {
        return this.fongo.getUsedDatabases();
    }

    public List<String> getDatabaseNames() {
        return this.fongo.getDatabaseNames();
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        return null;
    }

    public int getMaxBsonObjectSize() {
        return 0x1000000;
    }

    public DB getDB(String dbname) {
        return this.fongo.getDB(dbname);
    }

    public MongoDatabase getDatabase(String databaseName) {
        return new FongoMongoDatabase(databaseName, this.fongo);
    }

    public void dropDatabase(String dbName) {
        this.fongo.dropDatabase(dbName);
    }

    public MongoOptions getMongoOptions() {
        return this.options;
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.clientOptions;
    }

    public List<ServerAddress> getAllAddress() {
        return this.getServerAddressList();
    }

    public ServerAddress getAddress() {
        return this.fongo.getServerAddress();
    }

    public List<ServerAddress> getServerAddressList() {
        return Collections.singletonList(this.fongo.getServerAddress());
    }

    private ServerDescription getServerDescription() {
        return ServerDescription.builder().address(this.fongo.getServerAddress()).state(ServerConnectionState.CONNECTED).version(this.fongo.getServerVersion()).build();
    }

    public Cluster getCluster() {
        return new Cluster(){

            public ClusterSettings getSettings() {
                return ClusterSettings.builder().hosts(MockMongoClient.this.getServerAddressList()).requiredReplicaSetName(MockMongoClient.this.options.getRequiredReplicaSetName()).description(MockMongoClient.this.options.getDescription()).maxWaitQueueSize(10).build();
            }

            public ClusterDescription getDescription() {
                return new ClusterDescription(ClusterConnectionMode.SINGLE, ClusterType.STANDALONE, Collections.singletonList(MockMongoClient.this.getServerDescription()));
            }

            public Server selectServer(ServerSelector serverSelector) {
                return new Server(){

                    public ServerDescription getDescription() {
                        return new ObjenesisStd().getInstantiatorOf(ServerDescription.class).newInstance();
                    }

                    public Connection getConnection() {
                        return new FongoConnection(MockMongoClient.this.fongo);
                    }

                    public void getConnectionAsync(SingleResultCallback<AsyncConnection> callback) {
                    }
                };
            }

            public void selectServerAsync(ServerSelector serverSelector, SingleResultCallback<Server> callback) {
            }

            public void close() {
            }

            public boolean isClosed() {
                return false;
            }
        };
    }

    OperationExecutor createOperationExecutor() {
        return this.fongo;
    }

    public void close() {
    }

    synchronized BufferProvider getBufferProvider() {
        if (this.bufferProvider == null) {
            this.bufferProvider = new PowerOfTwoBufferPool();
        }
        return this.bufferProvider;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }
}

