/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.annotations.ThreadSafe;
import java.util.ArrayList;

@ThreadSafe
public class Unwind
extends PipelineKeyword {
    public static final Unwind INSTANCE = new Unwind();

    private Unwind() {
    }

    @Override
    public DBCollection apply(DB originalDB, DBCollection coll, DBObject object) {
        BasicDBObject unwindDBObject;
        String fieldName = null;
        boolean preserveNullAndEmptyArrays = false;
        Object unwindObject = object.get(this.getKeyword());
        if (unwindObject instanceof String) {
            fieldName = unwindObject.toString();
        } else if (unwindObject instanceof BasicDBObject && (unwindDBObject = (BasicDBObject)unwindObject).containsField("path")) {
            fieldName = unwindDBObject.getString("path");
            preserveNullAndEmptyArrays = this.getPreserveNullAndEmptyArrays(unwindDBObject);
        }
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new MongoException(28812, "no path specified to $unwind stage");
        }
        if (!fieldName.startsWith("$")) {
            throw new MongoException(28818, String.format("path option to $unwind stage should be prefixed with a '$': %s", fieldName));
        }
        fieldName = fieldName.substring(1);
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        for (DBObject dbObject : coll.find().toArray()) {
            if (Util.containsField(dbObject, fieldName)) {
                Object oValue = Util.extractField(dbObject, fieldName);
                if (!(oValue instanceof BasicDBList)) {
                    DBObject newValue = Util.clone(dbObject);
                    result.add(newValue);
                    continue;
                }
                BasicDBList list = (BasicDBList)oValue;
                for (Object sublist : list) {
                    DBObject newValue = Util.clone(dbObject);
                    Util.putValue(newValue, fieldName, sublist);
                    result.add(newValue);
                }
                if (!preserveNullAndEmptyArrays || !list.isEmpty()) continue;
                DBObject newValue = Util.clone(dbObject);
                Util.removeField(newValue, fieldName);
                result.add(newValue);
                continue;
            }
            if (!preserveNullAndEmptyArrays) continue;
            result.add(Util.clone(dbObject));
        }
        return this.dropAndInsert(coll, result);
    }

    private boolean getPreserveNullAndEmptyArrays(BasicDBObject unwindDBObject) {
        if (unwindDBObject.containsField("preserveNullAndEmptyArrays")) {
            String option = unwindDBObject.getString("preserveNullAndEmptyArrays");
            if (!"true".equalsIgnoreCase(option) && !"false".equalsIgnoreCase(option)) {
                throw new MongoException(28810, String.format("expected a boolean for the preserveNullAndEmptyArrays option to $unwind stage, got %s", option));
            }
            return Boolean.parseBoolean(option);
        }
        return false;
    }

    @Override
    public String getKeyword() {
        return "$unwind";
    }
}

