/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.index;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.index.IndexAbstract;
import com.github.fakemongo.impl.index.IndexedList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bson.BSONObject;

public class Index
extends IndexAbstract<DBObject> {
    Index(String name, DBObject keys, boolean unique) {
        super(name, keys, unique, Index.createMap(keys, unique), null);
    }

    private static Map<DBObject, IndexedList<DBObject>> createMap(DBObject keys, boolean unique) {
        if (unique && keys.containsField("_id") && keys.toMap().size() == 1) {
            return new LinkedHashMap<DBObject, IndexedList<DBObject>>();
        }
        return new TreeMap<DBObject, IndexedList<DBObject>>(new ExpressionParser().buildObjectComparator(Index.isAsc(keys)));
    }

    @Override
    public DBObject embedded(DBObject object) {
        return this.expandObject(object);
    }

    private DBObject expandObject(DBObject object) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        ArrayList<BasicDBObject> objectsToPut = new ArrayList<BasicDBObject>();
        for (String string : object.keySet()) {
            if (!string.contains(".")) continue;
            Object actualValue = object.get(string);
            BasicDBObject expandedObject = null;
            List<String> splittedKeys = Util.split(string);
            for (int i = splittedKeys.size() - 1; i >= 0; --i) {
                if (expandedObject == null) {
                    expandedObject = new BasicDBObject(splittedKeys.get(i), actualValue);
                    continue;
                }
                BasicDBObject partialObject = expandedObject;
                expandedObject = new BasicDBObject(splittedKeys.get(i), (Object)partialObject);
            }
            keysToRemove.add(string);
            objectsToPut.add(expandedObject);
        }
        for (String string : keysToRemove) {
            object.removeField(string);
        }
        for (DBObject dBObject : objectsToPut) {
            String rootElement = (String)dBObject.keySet().iterator().next();
            if (object.containsField(rootElement)) {
                DBObject objectToAdd = (DBObject)dBObject.get(rootElement);
                ((DBObject)object.get(rootElement)).putAll((BSONObject)objectToAdd);
                continue;
            }
            object.putAll((BSONObject)dBObject);
        }
        return object;
    }
}

