/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.FongoException;
import com.github.fakemongo.impl.Filter;
import com.github.fakemongo.impl.Util;
import com.github.fakemongo.impl.geo.GeoUtil;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRefBase;
import com.mongodb.LazyDBObject;
import com.mongodb.util.JSON;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.LazyBSONList;
import org.bson.types.Binary;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionParser {
    public static final String LT = "$lt";
    public static final String EQ = "$eq";
    public static final String LTE = "$lte";
    public static final String GT = "$gt";
    public static final String GTE = "$gte";
    public static final String NE = "$ne";
    public static final String ALL = "$all";
    public static final String EXISTS = "$exists";
    public static final String MOD = "$mod";
    public static final String IN = "$in";
    public static final String NIN = "$nin";
    public static final String SIZE = "$size";
    public static final String NOT = "$not";
    public static final String OR = "$or";
    public static final String AND = "$and";
    public static final String REGEX = "$regex";
    public static final String REGEX_OPTIONS = "$options";
    public static final String TYPE = "$type";
    public static final String NEAR = "$near";
    public static final String NEAR_SPHERE = "$nearSphere";
    public static final String MAX_DISTANCE = "$maxDistance";
    public static final String ELEM_MATCH = "$elemMatch";
    public static final String WHERE = "$where";
    public static final String GEO_WITHIN = "$geoWithin";
    public static final String SLICE = "$slice";
    public static final Filter AllFilter = new Filter(){

        @Override
        public boolean apply(DBObject o) {
            return true;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionParser.class);
    private static final Map<Class, Integer> CLASS_TO_WEIGHT;
    List<FilterFactory> filterFactories = Arrays.asList(new ConditionalOperatorFilterFactory("$gte"){

        @Override
        boolean singleCompare(Object queryValue, Object storedValue) {
            Integer result = ExpressionParser.this.compareObjects(queryValue, storedValue, true);
            return result != null && result <= 0;
        }
    }, new ConditionalOperatorFilterFactory("$lte"){

        @Override
        boolean singleCompare(Object queryValue, Object storedValue) {
            Integer result = ExpressionParser.this.compareObjects(queryValue, storedValue, true);
            return result != null && result >= 0;
        }
    }, new ConditionalOperatorFilterFactory("$gt"){

        @Override
        boolean singleCompare(Object queryValue, Object storedValue) {
            Integer result = ExpressionParser.this.compareObjects(queryValue, storedValue, true);
            return result != null && result < 0;
        }
    }, new ConditionalOperatorFilterFactory("$lt"){

        @Override
        boolean singleCompare(Object queryValue, Object storedValue) {
            Integer result = ExpressionParser.this.compareObjects(queryValue, storedValue, true);
            return result != null && result > 0;
        }
    }, new ConditionalOperatorFilterFactory("$eq"){

        @Override
        boolean singleCompare(Object queryValue, Object storedValue) {
            Integer result = ExpressionParser.this.compareObjects(queryValue, storedValue, true);
            return result != null && result == 0;
        }
    }, new BasicCommandFilterFactory("$ne"){

        @Override
        public Filter createFilter(final List<String> path, final DBObject refExpression) {
            return new Filter(){

                @Override
                public boolean apply(DBObject o) {
                    Object queryValue = refExpression.get(command);
                    List<Object> storedList = ExpressionParser.this.getEmbeddedValues(path, o);
                    if (storedList.isEmpty()) {
                        return queryValue != null;
                    }
                    for (Object storedValue : storedList) {
                        if (storedValue instanceof List) {
                            for (Object aValue : (List)storedValue) {
                                if (!this.isEqual(queryValue, aValue)) continue;
                                return false;
                            }
                        }
                        if (!this.isEqual(queryValue, storedValue)) continue;
                        return false;
                    }
                    return true;
                }

                private boolean isEqual(Object obj1, Object obj2) {
                    if (obj1 == null) {
                        return obj2 == null;
                    }
                    return obj1.equals(obj2);
                }
            };
        }
    }, new BasicFilterFactory("$all"){

        @Override
        boolean compare(Object queryValue, Object storedValue) {
            Collection queryList = ExpressionParser.this.typecast(this.command + " clause", queryValue, Collection.class);
            List storedList = ExpressionParser.this.typecast("value", storedValue, List.class);
            if (storedList == null) {
                return false;
            }
            for (Object queryObject : queryList) {
                if (!(queryObject instanceof Pattern ? !ExpressionParser.this.listContainsPattern(storedList, (Pattern)queryObject) : !storedList.contains(queryObject))) continue;
                return false;
            }
            return true;
        }
    }, new BasicFilterFactory("$elemMatch"){

        @Override
        boolean compare(Object queryValue, Object storedValue) {
            DBObject query = ExpressionParser.this.typecast(this.command + " clause", queryValue, DBObject.class);
            List storedList = ExpressionParser.this.typecast("value", storedValue, List.class);
            if (storedList == null) {
                return false;
            }
            if (((String)query.keySet().iterator().next()).startsWith("$")) {
                BasicDBObject dbObject = new BasicDBObject("$$$$fongo$$$$", (Object)query);
                Filter filter = ExpressionParser.this.buildFilter((DBObject)dbObject);
                for (Object object : storedList) {
                    if (object instanceof DBObject && ExpressionParser.this.buildFilter(query).apply((DBObject)object)) {
                        return true;
                    }
                    if (!filter.apply((DBObject)new BasicDBObject("$$$$fongo$$$$", object))) continue;
                    return true;
                }
            } else {
                Filter filter = ExpressionParser.this.buildFilter(query);
                for (Object object : storedList) {
                    if (!filter.apply((DBObject)object)) continue;
                    return true;
                }
            }
            return false;
        }
    }, new BasicCommandFilterFactory("$exists"){

        @Override
        public Filter createFilter(final List<String> path, final DBObject refExpression) {
            return new Filter(){

                @Override
                public boolean apply(DBObject o) {
                    List<Object> storedOption = ExpressionParser.this.getEmbeddedValues(path, o);
                    return ExpressionParser.this.typecast(command + " clause", refExpression.get(command), Boolean.class) == !storedOption.isEmpty();
                }
            };
        }
    }, new BasicFilterFactory("$mod"){

        @Override
        boolean compare(Object queryValue, Object storedValue) {
            List queryList = ExpressionParser.this.typecast(this.command + " clause", queryValue, List.class);
            ExpressionParser.this.enforce(queryList.size() == 2, this.command + " clause must be a List of size 2");
            Number modulus = (Number)queryList.get(0);
            Number expectedValue = (Number)queryList.get(1);
            return storedValue != null && ExpressionParser.this.typecast("value", storedValue, Number.class).longValue() % modulus.longValue() == expectedValue.longValue();
        }
    }, new InFilterFactory("$in", true), new InFilterFactory("$nin", false), new BasicFilterFactory("$size"){

        @Override
        boolean compare(Object queryValue, Object storedValue) {
            Integer size = ExpressionParser.this.typecast(this.command + " clause", queryValue, Integer.class);
            List storedList = ExpressionParser.this.typecast("value", storedValue, List.class);
            return storedList != null && storedList.size() == size.intValue();
        }
    }, new BasicCommandFilterFactory("$regex"){

        @Override
        public Filter createFilter(List<String> path, DBObject refExpression) {
            String flagStr = ExpressionParser.this.typecast(ExpressionParser.REGEX_OPTIONS, refExpression.get(ExpressionParser.REGEX_OPTIONS), String.class);
            int flags = ExpressionParser.this.parseRegexOptionsToPatternFlags(flagStr);
            Pattern pattern = Pattern.compile(refExpression.get(this.command).toString(), flags);
            return ExpressionParser.this.createPatternFilter(path, pattern);
        }
    }, new NearCommandFilterFactory("$nearSphere", true), new NearCommandFilterFactory("$near", false), new GeoWithinCommandFilterFactory("$geoWithin"), new BasicCommandFilterFactory("$type"){

        @Override
        public Filter createFilter(List<String> path, DBObject refExpression) {
            Number type = ExpressionParser.this.typecast(ExpressionParser.TYPE, refExpression.get(ExpressionParser.TYPE), Number.class);
            return ExpressionParser.this.createTypeFilter(path, type.intValue());
        }
    });

    public ObjectComparator objectComparator(int sortDirection) {
        if (sortDirection != -1 && sortDirection != 1) {
            throw new FongoException("The $sort element value must be either 1 or -1. Actual: " + sortDirection);
        }
        return new ObjectComparator(sortDirection == 1);
    }

    public SortSpecificationComparator sortSpecificationComparator(DBObject orderBy) {
        return new SortSpecificationComparator(orderBy);
    }

    private boolean isDBObjectButNotDBList(Object o) {
        return o instanceof DBObject && !(o instanceof List);
    }

    public Filter buildFilter(DBObject ref) {
        AndFilter andFilter = new AndFilter();
        if (ref != null) {
            for (String key : ref.keySet()) {
                Object expression = ref.get(key);
                andFilter.addFilter(this.buildExpressionFilter(key, expression));
            }
        }
        return andFilter;
    }

    public Filter buildFilter(DBObject ref, Collection<String> keys) {
        AndFilter andFilter = new AndFilter();
        for (String key : ref.keySet()) {
            if (!keys.contains(key)) continue;
            Object expression = ref.get(key);
            andFilter.addFilter(this.buildExpressionFilter(key, expression));
        }
        return andFilter;
    }

    public <T> T typecast(String fieldName, Object obj, Class<T> clazz) {
        try {
            return clazz.cast(obj);
        }
        catch (Exception e) {
            throw new FongoException(fieldName + " expected to be of type " + clazz.getName() + " but is " + (obj != null ? obj.getClass() : "null") + " toString:" + obj);
        }
    }

    private void enforce(boolean check, String message) {
        if (!check) {
            throw new FongoException(message);
        }
    }

    boolean objectMatchesPattern(Object obj, Pattern pattern) {
        return obj instanceof CharSequence && pattern.matcher((CharSequence)obj).find();
    }

    boolean listContainsPattern(List<Object> list, Pattern pattern) {
        for (Object obj : list) {
            if (!this.objectMatchesPattern(obj, pattern)) continue;
            return true;
        }
        return false;
    }

    boolean objectMatchesType(Object obj, int type) {
        switch (type) {
            case 1: {
                return obj instanceof Double || obj instanceof Float;
            }
            case 2: {
                return obj instanceof CharSequence;
            }
            case 3: {
                return this.isDBObjectButNotDBList(obj);
            }
            case 4: {
                return obj instanceof List;
            }
            case 7: {
                return obj instanceof ObjectId;
            }
            case 8: {
                return obj instanceof Boolean;
            }
            case 9: {
                return obj instanceof Date;
            }
            case 10: {
                return obj == null;
            }
            case 11: {
                return obj instanceof Pattern;
            }
            case 16: {
                return obj instanceof Integer;
            }
            case 18: {
                return obj instanceof Long;
            }
        }
        return false;
    }

    public List<Object> getEmbeddedValues(List<String> path, DBObject dbo) {
        return this.getEmbeddedValues(path, 0, dbo);
    }

    public List<Object> getEmbeddedValues(String key, DBObject dbo) {
        return this.getEmbeddedValues(Util.split(key), 0, dbo);
    }

    public List<Object> extractDBRefValue(DBRefBase ref, String refKey) {
        if ("$id".equals(refKey)) {
            return Collections.singletonList(ref.getId());
        }
        if ("$ref".equals(refKey)) {
            return Collections.singletonList(ref.getRef());
        }
        if ("$db".equals(refKey)) {
            return Collections.singletonList(ref.getDB());
        }
        return Collections.emptyList();
    }

    public List<Object> getEmbeddedValues(List<String> path, int startIndex, DBObject dbo) {
        String subKey = path.get(startIndex);
        if (path.size() > 1 && LOG.isDebugEnabled()) {
            LOG.debug("getEmbeddedValue looking for {} in {}", path, (Object)dbo);
        }
        for (int i = startIndex; i < path.size() - 1; ++i) {
            Object value = dbo.get(subKey);
            if (value instanceof DBObject && !(value instanceof List)) {
                dbo = (DBObject)value;
            } else if (value instanceof List && Util.isPositiveInt(path.get(i + 1))) {
                BasicDBList newList = Util.wrap((List)value);
                dbo = newList;
            } else if (value instanceof List) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object listValue : (List)value) {
                    if (listValue instanceof DBObject) {
                        List<Object> embeddedListValue = this.getEmbeddedValues(path, i + 1, (DBObject)listValue);
                        results.addAll(embeddedListValue);
                        continue;
                    }
                    if (!(listValue instanceof DBRefBase)) continue;
                    results.addAll(this.extractDBRefValue((DBRefBase)listValue, path.get(i + 1)));
                }
                if (!results.isEmpty()) {
                    return results;
                }
            } else {
                if (value instanceof DBRefBase) {
                    return this.extractDBRefValue((DBRefBase)value, path.get(i + 1));
                }
                return Collections.emptyList();
            }
            subKey = path.get(i + 1);
        }
        if (dbo.containsField(subKey)) {
            return Collections.singletonList(dbo.get(subKey));
        }
        return Collections.emptyList();
    }

    private Filter buildExpressionFilter(String key, Object expression) {
        return this.buildExpressionFilter(Util.split(key), expression);
    }

    private Filter buildExpressionFilter(List<String> path, Object expression) {
        if (OR.equals(path.get(0))) {
            Collection queryList = this.typecast(path + " operator", expression, Collection.class);
            OrFilter orFilter = new OrFilter();
            for (DBObject query : queryList) {
                orFilter.addFilter(this.buildFilter(query));
            }
            return orFilter;
        }
        if (AND.equals(path.get(0))) {
            Collection queryList = this.typecast(path + " operator", expression, Collection.class);
            AndFilter andFilter = new AndFilter();
            for (DBObject query : queryList) {
                andFilter.addFilter(this.buildFilter(query));
            }
            return andFilter;
        }
        if (WHERE.equals(path.get(0))) {
            return new WhereFilter((String)expression);
        }
        if (expression instanceof DBObject || expression instanceof Map) {
            DBObject ref;
            Object object = ref = expression instanceof DBObject ? (DBObject)expression : new BasicDBObject((Map)expression);
            if (ref.containsField(NOT)) {
                return new NotFilter(this.buildExpressionFilter(path, ref.get(NOT)));
            }
            AndFilter andFilter = new AndFilter();
            int matchCount = 0;
            for (FilterFactory filterFactory : this.filterFactories) {
                if (!filterFactory.matchesCommand(ref)) continue;
                ++matchCount;
                andFilter.addFilter(filterFactory.createFilter(path, ref));
            }
            if (matchCount == 0) {
                return this.simpleFilter(path, expression);
            }
            if (matchCount > 2) {
                throw new FongoException("Invalid expression for key " + path + ": " + expression);
            }
            return andFilter;
        }
        if (expression instanceof Pattern) {
            return this.createPatternFilter(path, (Pattern)expression);
        }
        return this.simpleFilter(path, expression);
    }

    public Filter simpleFilter(final List<String> path, final Object expression) {
        return new Filter(){

            @Override
            public boolean apply(DBObject o) {
                List<Object> storedOption = ExpressionParser.this.getEmbeddedValues(path, o);
                if (storedOption.isEmpty()) {
                    return expression == null;
                }
                for (Object storedValue : storedOption) {
                    if (storedValue instanceof List) {
                        if (expression instanceof Collection) {
                            return storedValue.equals(expression) || ExpressionParser.this.contains((Collection)((List)storedValue), (Collection)expression);
                        }
                        if (!ExpressionParser.this.contains((Collection)((List)storedValue), expression)) continue;
                        return true;
                    }
                    if (expression == null) {
                        return storedValue == null;
                    }
                    if ((long)ExpressionParser.this.compareObjects(expression, storedValue) != 0L) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public int compareObjects(Object queryValue, Object storedValue) {
        return this.compareObjects(queryValue, storedValue, false);
    }

    private Integer compareObjects(Object queryValue, Object storedValue, boolean comparableFilter) {
        LOG.debug("comparing {} and {}", queryValue, storedValue);
        if (this.isDBObjectButNotDBList(queryValue) && this.isDBObjectButNotDBList(storedValue)) {
            return this.compareDBObjects((DBObject)queryValue, (DBObject)storedValue);
        }
        if (queryValue instanceof List && storedValue instanceof List) {
            List queryList = (List)queryValue;
            List storedList = (List)storedValue;
            return this.compareLists(queryList, storedList, comparableFilter);
        }
        Object queryComp = this.typecast("query value", queryValue, Object.class);
        if (comparableFilter && !(storedValue instanceof Comparable)) {
            if (queryComp.equals(storedValue)) {
                return 0;
            }
            return null;
        }
        Object storedComp = this.typecast("stored value", storedValue, Object.class);
        return this.compareTo(queryComp, storedComp, comparableFilter);
    }

    protected int compareTo(Object c1, Object c2) {
        return this.compareTo(c1, c2, false);
    }

    protected Integer compareTo(Object c1, Object c2, boolean comparableFilter) {
        Class clazz2;
        Object cc1 = c1;
        Object cc2 = c2;
        Class clazz1 = c1 == null ? Null.class : c1.getClass();
        Class clazz = clazz2 = c2 == null ? Null.class : c2.getClass();
        if (!clazz1.isAssignableFrom(clazz2) || !(cc1 instanceof Comparable)) {
            Coordinate ll2;
            Coordinate ll1;
            boolean checkTypes = true;
            if (cc1 instanceof Number && cc2 instanceof Number) {
                cc1 = new BigDecimal(cc1.toString());
                cc2 = new BigDecimal(cc2.toString());
                checkTypes = false;
            }
            if (cc1 instanceof Binary) {
                cc1 = this.convertFrom((Binary)cc1);
                checkTypes = false;
            }
            if (cc2 instanceof Binary) {
                cc2 = this.convertFrom((Binary)cc2);
                checkTypes = false;
            }
            if (cc1 instanceof byte[]) {
                cc1 = this.convertFrom((byte[])cc1);
                checkTypes = false;
            }
            if (cc2 instanceof byte[]) {
                cc2 = this.convertFrom((byte[])cc2);
                checkTypes = false;
            }
            if ((ll1 = GeoUtil.coordinate(cc1)) != null && (ll2 = GeoUtil.coordinate(cc2)) != null) {
                cc1 = ll1;
                cc2 = ll2;
                checkTypes = false;
            }
            if (cc1 instanceof DBRefBase && cc2 instanceof DBRefBase) {
                DBRefBase a1 = (DBRefBase)cc1;
                DBRefBase a2 = (DBRefBase)cc2;
                if (a1.equals((Object)a2)) {
                    return 0;
                }
                cc1 = a1.toString();
                cc2 = a2.toString();
                checkTypes = false;
            }
            if (cc1 instanceof UUID && !(cc2 instanceof UUID)) {
                return -1;
            }
            if (cc2 instanceof UUID && !(cc1 instanceof UUID)) {
                return 1;
            }
            if (checkTypes) {
                Integer type1 = CLASS_TO_WEIGHT.get(clazz1);
                Integer type2 = CLASS_TO_WEIGHT.get(clazz2);
                if (type1 != null && type2 != null) {
                    cc1 = type1;
                    cc2 = type2;
                } else {
                    if (!comparableFilter) {
                        throw new FongoException("Don't know how to compare " + cc1.getClass() + " and " + cc2.getClass() + " values are : " + c1 + " vs " + c2);
                    }
                    return null;
                }
            }
        }
        return ((Comparable)cc1).compareTo(cc2);
    }

    private Comparable<String> convertFrom(Binary binary) {
        return new String(binary.getData());
    }

    private Comparable<String> convertFrom(byte[] array) {
        return new String(array);
    }

    public boolean contains(Collection source, Object element) {
        for (Object objectSource : source) {
            if (this.compareObjects(objectSource, element) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Collection source, Collection elements) {
        for (Object element : elements) {
            if (this.contains(source, element)) continue;
            return false;
        }
        return true;
    }

    public int compareLists(List queryList, List storedList) {
        return this.compareLists(queryList, storedList, false);
    }

    private Integer compareLists(List queryList, List storedList, boolean comparableFilter) {
        int sizeDiff = queryList.size() - storedList.size();
        if (sizeDiff != 0) {
            boolean bothEmpty;
            if (sizeDiff > 0 && queryList.get(storedList.size()) instanceof MinKey) {
                return -1;
            }
            if (sizeDiff < 0 && storedList.get(queryList.size()) instanceof MinKey) {
                return 1;
            }
            if (sizeDiff < 0 && storedList.get(queryList.size()) instanceof MaxKey) {
                return -1;
            }
            if (sizeDiff > 0 && queryList.get(storedList.size()) instanceof MaxKey) {
                return 1;
            }
            boolean bl = bothEmpty = this.isEmptyOrContainsOnlyNull(storedList) && this.isEmptyOrContainsOnlyNull(queryList);
            if (bothEmpty) {
                return 0;
            }
            return sizeDiff;
        }
        int length = queryList.size();
        for (int i = 0; i < length; ++i) {
            Integer compareValue = this.compareObjects(queryList.get(i), storedList.get(i), comparableFilter);
            if (compareValue == null) {
                return -1;
            }
            if (compareValue == 0) continue;
            return compareValue;
        }
        return 0;
    }

    private boolean isEmptyOrContainsOnlyNull(List list) {
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    private int compareDBObjects(DBObject db0, DBObject db1) {
        Iterator i0 = db0.keySet().iterator();
        Iterator i1 = db1.keySet().iterator();
        while (i0.hasNext() || i1.hasNext()) {
            Object value1;
            String key1;
            String key0 = i0.hasNext() ? (String)i0.next() : null;
            int keyComparison = Util.compareToNullable(key0, key1 = i1.hasNext() ? (String)i1.next() : null);
            if (keyComparison != 0) {
                return keyComparison;
            }
            Object value0 = key0 == null ? null : db0.get(key0);
            int valueComparison = this.compareObjects(value0, value1 = key1 == null ? null : db1.get(key1));
            if (valueComparison == 0) continue;
            return valueComparison;
        }
        return 0;
    }

    public Filter createPatternFilter(final List<String> path, final Pattern pattern) {
        return new Filter(){

            @Override
            public boolean apply(DBObject o) {
                List<Object> storedOption = ExpressionParser.this.getEmbeddedValues(path, o);
                if (storedOption.isEmpty()) {
                    return false;
                }
                for (Object storedValue : storedOption) {
                    if (storedValue == null || !(storedValue instanceof List ? ExpressionParser.this.listContainsPattern((List)storedValue, pattern) : ExpressionParser.this.objectMatchesPattern(storedValue, pattern))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Filter createTypeFilter(final List<String> path, final int type) {
        return new Filter(){

            @Override
            public boolean apply(DBObject o) {
                List<Object> storedOption = ExpressionParser.this.getEmbeddedValues(path, o);
                if (storedOption.isEmpty()) {
                    return false;
                }
                for (Object storedValue : storedOption) {
                    if (storedValue instanceof Collection) {
                        for (Object object : (Collection)storedValue) {
                            if (!ExpressionParser.this.objectMatchesType(object, type)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!ExpressionParser.this.objectMatchesType(storedValue, type)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Filter createNearFilter(final List<String> path, final Number maxDistance, final Geometry geometry, final boolean sphere) {
        return new Filter(){

            @Override
            public boolean apply(DBObject o) {
                Geometry objectGeometry = GeoUtil.toGeometry((DBObject)Util.extractField(o, path));
                double distance = GeoUtil.distanceInRadians(geometry, objectGeometry, sphere);
                o.put("$$$$$FONGO_ORDER_BY$$$$$", (Object)distance);
                return maxDistance == null || distance < maxDistance.doubleValue();
            }
        };
    }

    private Filter createGeowithinFilter(final List<String> path, final Geometry geometry) {
        return new Filter(){

            @Override
            public boolean apply(DBObject o) {
                Geometry local = GeoUtil.toGeometry(Util.extractField(o, path));
                return GeoUtil.geowithin(local, geometry);
            }
        };
    }

    public int parseRegexOptionsToPatternFlags(String flagString) {
        int flags = 0;
        block6: for (int i = 0; flagString != null && i < flagString.length(); ++i) {
            switch (flagString.charAt(i)) {
                case 'i': {
                    flags |= 2;
                    continue block6;
                }
                case 'x': {
                    flags |= 4;
                    continue block6;
                }
                case 'm': {
                    flags |= 8;
                    continue block6;
                }
                case 's': {
                    flags |= 0x20;
                }
            }
        }
        return flags;
    }

    public ObjectComparator buildObjectComparator(boolean asc) {
        return new ObjectComparator(asc);
    }

    static {
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(MinKey.class, Integer.MIN_VALUE);
        map.put(Null.class, 0);
        map.put(Double.class, 1);
        map.put(Float.class, 1);
        map.put(Integer.class, 1);
        map.put(Long.class, 1);
        map.put(Short.class, 1);
        map.put(String.class, 2);
        map.put(Object.class, 3);
        map.put(BasicDBObject.class, 4);
        map.put(LazyDBObject.class, 4);
        map.put(BasicDBList.class, 5);
        map.put(LazyBSONList.class, 5);
        map.put(byte[].class, 6);
        map.put(Binary.class, 6);
        map.put(ObjectId.class, 7);
        map.put(Boolean.class, 8);
        map.put(Date.class, 9);
        map.put(Pattern.class, 10);
        map.put(MaxKey.class, Integer.MAX_VALUE);
        CLASS_TO_WEIGHT = Collections.unmodifiableMap(map);
    }

    abstract class ConditionalOperatorFilterFactory
    extends BasicFilterFactory {
        public ConditionalOperatorFilterFactory(String command) {
            super(command);
        }

        @Override
        final boolean compare(Object queryValue, Object storedValue) {
            if (storedValue instanceof List) {
                for (Object aValue : (List)storedValue) {
                    if (aValue == null || !this.singleCompare(queryValue, aValue)) continue;
                    return true;
                }
                return false;
            }
            return storedValue != null && this.singleCompare(queryValue, storedValue);
        }

        abstract boolean singleCompare(Object var1, Object var2);
    }

    private final class GeoWithinCommandFilterFactory
    extends BasicCommandFilterFactory {
        public GeoWithinCommandFilterFactory(String command) {
            super(command);
        }

        @Override
        public Filter createFilter(List<String> path, DBObject refExpression) {
            LOG.debug("geoWithin path:{}, refExp:{}", path, (Object)refExpression);
            Geometry geometry = GeoUtil.toGeometry(ExpressionParser.this.typecast(ExpressionParser.GEO_WITHIN, refExpression.get(ExpressionParser.GEO_WITHIN), DBObject.class));
            return ExpressionParser.this.createGeowithinFilter(path, geometry);
        }
    }

    private final class NearCommandFilterFactory
    extends BasicCommandFilterFactory {
        final boolean spherical;

        public NearCommandFilterFactory(String command, boolean spherical) {
            super(command);
            this.spherical = spherical;
        }

        @Override
        public Filter createFilter(List<String> path, DBObject refExpression) {
            Number maxDistance;
            Point geometry;
            LOG.debug("path:{}, refExp:{}", path, (Object)refExpression);
            if (refExpression.get(this.command) instanceof BasicDBList) {
                List<Coordinate> coordinates = GeoUtil.coordinate(Collections.singletonList(this.command), refExpression);
                geometry = GeoUtil.createGeometryPoint(coordinates.get(0));
                maxDistance = ExpressionParser.this.typecast(ExpressionParser.MAX_DISTANCE, refExpression.get(ExpressionParser.MAX_DISTANCE), Number.class);
            } else {
                DBObject dbObject = ExpressionParser.this.typecast(this.command, refExpression.get(this.command), DBObject.class);
                geometry = GeoUtil.toGeometry((DBObject)Util.extractField(dbObject, "$geometry"));
                maxDistance = ExpressionParser.this.typecast(ExpressionParser.MAX_DISTANCE, dbObject.get(ExpressionParser.MAX_DISTANCE), Number.class);
                if (maxDistance != null) {
                    maxDistance = maxDistance.doubleValue() / 6378100.0;
                }
            }
            return ExpressionParser.this.createNearFilter(path, maxDistance, (Geometry)geometry, this.spherical);
        }
    }

    private final class InFilterFactory
    extends BasicCommandFilterFactory {
        private final boolean direction;

        public InFilterFactory(String command, boolean direction) {
            super(command);
            this.direction = direction;
        }

        @Override
        public Filter createFilter(final List<String> path, final DBObject refExpression) {
            Collection queryList = ExpressionParser.this.typecast(this.command + " clause", refExpression.get(this.command), Collection.class);
            final HashSet querySet = new HashSet(queryList);
            return new Filter(){

                @Override
                public boolean apply(DBObject o) {
                    List<Object> storedList = ExpressionParser.this.getEmbeddedValues(path, o);
                    if (storedList.isEmpty()) {
                        return querySet.contains(null) ? InFilterFactory.this.direction : !InFilterFactory.this.direction;
                    }
                    for (Object storedValue : storedList) {
                        if (InFilterFactory.this.compare(refExpression.get(InFilterFactory.this.command), storedValue, querySet) != InFilterFactory.this.direction) continue;
                        return InFilterFactory.this.direction;
                    }
                    return !InFilterFactory.this.direction;
                }
            };
        }

        boolean compare(Object queryValueIgnored, Object storedValue, Set querySet) {
            if (storedValue instanceof List) {
                for (Object valueItem : (List)storedValue) {
                    if (!this.containsWithRegex(querySet, valueItem)) continue;
                    return this.direction;
                }
                if (this.containsWithRegex(querySet, storedValue)) {
                    return this.direction;
                }
                return !this.direction;
            }
            return !(this.direction ^ this.containsWithRegex(querySet, storedValue));
        }

        boolean containsWithRegex(Set querySet, Object storedValue) {
            for (Object queryObject : querySet) {
                if (!Integer.valueOf(0).equals(ExpressionParser.this.compareObjects(queryObject, storedValue, true))) continue;
                return true;
            }
            if (storedValue instanceof CharSequence) {
                CharSequence s = (CharSequence)storedValue;
                for (Object o : querySet) {
                    Pattern p;
                    if (!(o instanceof Pattern) || !(p = (Pattern)o).matcher(s).find()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private final class WhereFilter
    implements Filter {
        private final String expression;

        public WhereFilter(String expression) {
            this.expression = expression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean apply(DBObject o) {
            Context cx = Context.enter();
            try {
                ScriptableObject scope = cx.initStandardObjects();
                String json = JSON.serialize((Object)o);
                String expr = "obj=" + json + ";\n" + this.expression.replace("this.", "obj.") + ";\n";
                try {
                    boolean bl = (Boolean)cx.evaluateString((Scriptable)scope, expr, "<$where>", 0, null);
                    return bl;
                }
                catch (Exception e) {
                    LOG.error("Exception evaluating javascript expression {}", (Object)this.expression, (Object)e);
                    cx.exit();
                }
            }
            finally {
                cx.exit();
            }
            return false;
        }
    }

    abstract class BasicFilterFactory
    extends BasicCommandFilterFactory {
        public BasicFilterFactory(String command) {
            super(command);
        }

        @Override
        public boolean matchesCommand(DBObject refExpression) {
            return refExpression.containsField(this.command);
        }

        @Override
        public Filter createFilter(final List<String> path, final DBObject refExpression) {
            return new Filter(){

                @Override
                public boolean apply(DBObject o) {
                    List<Object> storedList = ExpressionParser.this.getEmbeddedValues(path, o);
                    if (storedList.isEmpty()) {
                        return false;
                    }
                    for (Object storedValue : storedList) {
                        if (!BasicFilterFactory.this.compare(refExpression.get(BasicFilterFactory.this.command), storedValue)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        abstract boolean compare(Object var1, Object var2);
    }

    abstract class BasicCommandFilterFactory
    implements FilterFactory {
        public final String command;

        public BasicCommandFilterFactory(String command) {
            this.command = command;
        }

        @Override
        public boolean matchesCommand(DBObject refExpression) {
            return refExpression.containsField(this.command);
        }
    }

    public class SortSpecificationComparator
    implements Comparator<Object> {
        private final DBObject orderBy;
        private final Set<String> orderByKeySet;

        public SortSpecificationComparator(DBObject orderBy) {
            this.orderBy = orderBy;
            this.orderByKeySet = orderBy.keySet();
            if (this.orderByKeySet.isEmpty()) {
                throw new FongoException("The $sort pattern is empty when it should be a set of fields.");
            }
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (ExpressionParser.this.isDBObjectButNotDBList(o1) && ExpressionParser.this.isDBObjectButNotDBList(o2)) {
                DBObject dbo1 = (DBObject)o1;
                DBObject dbo2 = (DBObject)o2;
                for (String sortKey : this.orderByKeySet) {
                    List<Object> o2list;
                    List<String> path = Util.split(sortKey);
                    int sortDirection = (Integer)this.orderBy.get(sortKey);
                    List<Object> o1list = ExpressionParser.this.getEmbeddedValues(path, dbo1);
                    int compareValue = ExpressionParser.this.compareLists(o1list, o2list = ExpressionParser.this.getEmbeddedValues(path, dbo2), false) * sortDirection;
                    if (compareValue == 0) continue;
                    return compareValue;
                }
                return 0;
            }
            if (ExpressionParser.this.isDBObjectButNotDBList(o1) || ExpressionParser.this.isDBObjectButNotDBList(o2)) {
                DBObject dbo = (DBObject)(o1 instanceof DBObject ? o1 : o2);
                for (String sortKey : this.orderByKeySet) {
                    List<String> path = Util.split(sortKey);
                    int sortDirection = (Integer)this.orderBy.get(sortKey);
                    List<Object> foundValues = ExpressionParser.this.getEmbeddedValues(path, dbo);
                    if (foundValues.isEmpty()) continue;
                    return o1 instanceof DBObject ? sortDirection : -sortDirection;
                }
                return ExpressionParser.this.compareTo(o1, o2);
            }
            return ExpressionParser.this.compareTo(o1, o2);
        }
    }

    public class ObjectComparator
    implements Comparator {
        private final int asc;

        ObjectComparator(boolean asc) {
            this.asc = asc ? 1 : -1;
        }

        public int compare(Object o1, Object o2) {
            return this.asc * ExpressionParser.this.compareObjects(o1, o2);
        }
    }

    static class OrFilter
    extends ConjunctionFilter {
        OrFilter() {
        }

        @Override
        public boolean apply(DBObject o) {
            for (Filter f : this.filters) {
                if (!f.apply(o)) continue;
                return true;
            }
            return false;
        }
    }

    static class AndFilter
    extends ConjunctionFilter {
        AndFilter() {
        }

        @Override
        public boolean apply(DBObject o) {
            for (Filter f : this.filters) {
                if (f.apply(o)) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class ConjunctionFilter
    implements Filter {
        final List<Filter> filters = new ArrayList<Filter>();

        ConjunctionFilter() {
        }

        public void addFilter(Filter filter) {
            this.filters.add(filter);
        }
    }

    static class NotFilter
    implements Filter {
        private final Filter filter;

        public NotFilter(Filter filter) {
            this.filter = filter;
        }

        @Override
        public boolean apply(DBObject o) {
            return !this.filter.apply(o);
        }
    }

    private static class Null {
        private Null() {
        }
    }

    static interface FilterFactory {
        public boolean matchesCommand(DBObject var1);

        public Filter createFilter(List<String> var1, DBObject var2);
    }
}

