/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo;

import com.mongodb.DB;
import com.mongodb.FongoDB;
import com.mongodb.MockMongoClient;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Fongo {
    private final Map<String, FongoDB> dbMap = new ConcurrentHashMap<String, FongoDB>();
    private final ServerAddress serverAddress;
    private final MongoClient mongo;
    private final String name;

    public Fongo(String name) {
        this.name = name;
        this.serverAddress = new ServerAddress(new InetSocketAddress(ServerAddress.defaultHost(), ServerAddress.defaultPort()));
        this.mongo = this.createMongo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB getDB(String dbname) {
        Map<String, FongoDB> map = this.dbMap;
        synchronized (map) {
            FongoDB fongoDb = this.dbMap.get(dbname);
            if (fongoDb == null) {
                fongoDb = new FongoDB(this, dbname);
                this.dbMap.put(dbname, fongoDb);
            }
            return fongoDb;
        }
    }

    public Collection<DB> getUsedDatabases() {
        return new ArrayList<DB>(this.dbMap.values());
    }

    public List<String> getDatabaseNames() {
        return new ArrayList<String>(this.dbMap.keySet());
    }

    public void dropDatabase(String dbName) {
        FongoDB db = this.dbMap.remove(dbName);
        if (db != null) {
            db.dropDatabase();
        }
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public WriteConcern getWriteConcern() {
        return this.mongo.getWriteConcern();
    }

    private MongoClient createMongo() {
        return MockMongoClient.create(this);
    }

    public String toString() {
        return "Fongo (" + this.name + ")";
    }
}

