/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.rfc4122;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;

public final class TimeOrderedEpochFactory
extends AbstCombFactory {
    private UUID lastUuid;
    private final int incrementType;
    private final LongSupplier incrementSupplier;
    private static final int INCREMENT_TYPE_DEFAULT = 0;
    private static final int INCREMENT_TYPE_PLUS_1 = 1;
    private static final int INCREMENT_TYPE_PLUS_N = 2;
    protected static final int CLOCK_DRIFT_TOLERANCE = 10000;

    public TimeOrderedEpochFactory() {
        this(TimeOrderedEpochFactory.builder());
    }

    public TimeOrderedEpochFactory(Clock clock) {
        this((Builder)TimeOrderedEpochFactory.builder().withClock(clock));
    }

    public TimeOrderedEpochFactory(Random random) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandom(random));
    }

    public TimeOrderedEpochFactory(Random random, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandom(random)).withClock(clock));
    }

    public TimeOrderedEpochFactory(LongSupplier randomFunction) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction));
    }

    public TimeOrderedEpochFactory(IntFunction<byte[]> randomFunction) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandomFunction((IntFunction)randomFunction));
    }

    public TimeOrderedEpochFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    public TimeOrderedEpochFactory(IntFunction<byte[]> randomFunction, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandomFunction((IntFunction)randomFunction)).withClock(clock));
    }

    private TimeOrderedEpochFactory(Builder builder) {
        super(UuidVersion.VERSION_TIME_ORDERED_EPOCH, builder);
        this.incrementType = builder.getIncrementType();
        this.incrementSupplier = builder.getIncrementSupplier();
        this.lastUuid = this.make(0L, this.random.nextLong(), this.random.nextLong());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public synchronized UUID create() {
        long lastTime;
        long time = this.clock.millis();
        if (time > (lastTime = this.lastUuid.getMostSignificantBits() >>> 16) - 10000L && time <= lastTime) {
            this.lastUuid = this.increment(this.lastUuid);
        } else if (this.random instanceof AbstRandomBasedFactory.ByteRandom) {
            byte[] bytes = this.random.nextBytes(10);
            long long1 = ByteUtil.toNumber(bytes, 0, 2);
            long long2 = ByteUtil.toNumber(bytes, 2, 10);
            this.lastUuid = this.make(time, long1, long2);
        } else {
            long long1 = this.random.nextLong();
            long long2 = this.random.nextLong();
            this.lastUuid = this.make(time, long1, long2);
        }
        return this.copy(this.lastUuid);
    }

    private synchronized UUID increment(UUID uuid) {
        long overflow = 0L;
        long versionMask = 61440L;
        long variantMask = -4611686018427387904L;
        long msb = uuid.getMostSignificantBits() | 0xF000L;
        long lsb = (uuid.getLeastSignificantBits() | 0xC000000000000000L) + this.incrementSupplier.getAsLong();
        if (0 == this.incrementType) {
            long clearMask = -281474976710656L;
            if ((lsb & 0xFFFF000000000000L) == 0L) {
                ++msb;
            }
            lsb &= 0xFFFF000000000000L;
            lsb |= ByteUtil.toNumber(this.random.nextBytes(6));
        } else if (lsb == 0L) {
            ++msb;
        }
        return this.toUuid(msb, lsb);
    }

    private UUID make(long time, long long1, long long2) {
        return this.toUuid(time << 16 | long1 & 0xFFFFL, long2);
    }

    private synchronized UUID copy(UUID uuid) {
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static class Builder
    extends AbstCombFactory.Builder<TimeOrderedEpochFactory, Builder> {
        private Integer incrementType;
        private Long incrementMax;

        public Builder withIncrementPlus1() {
            this.incrementType = 1;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN() {
            this.incrementType = 2;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN(long incrementMax) {
            this.incrementType = 2;
            this.incrementMax = incrementMax;
            return this;
        }

        protected int getIncrementType() {
            if (this.incrementType == null) {
                this.incrementType = 0;
            }
            return this.incrementType;
        }

        protected LongSupplier getIncrementSupplier() {
            switch (this.getIncrementType()) {
                case 1: {
                    return () -> 1L;
                }
                case 2: {
                    if (this.incrementMax == null) {
                        if (this.random instanceof AbstRandomBasedFactory.ByteRandom) {
                            return () -> {
                                byte[] bytes = this.random.nextBytes(4);
                                return ByteUtil.toNumber(bytes, 0, 4) + 1L;
                            };
                        }
                        return () -> (this.random.nextLong() >>> 32) + 1L;
                    }
                    long positive = Long.MAX_VALUE;
                    if (this.random instanceof AbstRandomBasedFactory.ByteRandom) {
                        int bits = (int)Math.ceil(Math.log(this.incrementMax.longValue()) / Math.log(2.0));
                        int size = (bits - 1) / 8 + 1;
                        return () -> {
                            byte[] bytes = this.random.nextBytes(size);
                            long random = ByteUtil.toNumber(bytes, 0, size);
                            return (random & Long.MAX_VALUE) % this.incrementMax + 1L;
                        };
                    }
                    return () -> (this.random.nextLong() & Long.MAX_VALUE) % this.incrementMax + 1L;
                }
            }
            return () -> 0x1000000000000L;
        }

        @Override
        public TimeOrderedEpochFactory build() {
            return new TimeOrderedEpochFactory(this);
        }
    }
}

