/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstNameBasedFactory
extends UuidFactory {
    protected byte[] namespace = null;
    protected final String algorithm;
    protected static final String ALGORITHM_MD5 = "MD5";
    protected static final String ALGORITHM_SHA1 = "SHA-1";

    protected AbstNameBasedFactory(UuidVersion version, String algorithm, byte[] namespace) {
        super(version);
        if (!UuidVersion.VERSION_NAME_BASED_MD5.equals((Object)version) && !UuidVersion.VERSION_NAME_BASED_SHA1.equals((Object)version)) {
            throw new IllegalArgumentException("Invalid UUID version");
        }
        if (!ALGORITHM_MD5.equals(algorithm) && !ALGORITHM_SHA1.equals(algorithm)) {
            throw new IllegalArgumentException("Invalid message digest algorithm");
        }
        this.algorithm = algorithm;
        if (namespace == null) {
            this.namespace = null;
        } else if (namespace.length == 16) {
            this.namespace = namespace;
        } else {
            throw new IllegalArgumentException("Invalid namespace length");
        }
    }

    public UUID create(byte[] name) {
        return this.create(this.namespace, name);
    }

    public UUID create(String name) {
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(this.namespace, n);
    }

    public UUID create(UUID name) {
        return this.create(this.namespace, AbstNameBasedFactory.bytes(name));
    }

    public UUID create(UUID namespace, byte[] name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        return this.create(ns, name);
    }

    public UUID create(UUID namespace, String name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(UUID namespace, UUID name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        byte[] n = AbstNameBasedFactory.bytes(name);
        return this.create(ns, n);
    }

    public UUID create(String namespace, byte[] name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        return this.create(ns, name);
    }

    public UUID create(String namespace, String name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(String namespace, UUID name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        byte[] n = AbstNameBasedFactory.bytes(name);
        return this.create(ns, n);
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        return this.create(ns, name);
    }

    public UUID create(UuidNamespace namespace, String name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        byte[] n = name.getBytes(StandardCharsets.UTF_8);
        return this.create(ns, n);
    }

    public UUID create(UuidNamespace namespace, UUID name) {
        byte[] ns = namespace == null ? null : AbstNameBasedFactory.bytes(namespace);
        byte[] n = AbstNameBasedFactory.bytes(name);
        return this.create(ns, n);
    }

    protected static byte[] bytes(UuidNamespace namespace) {
        return AbstNameBasedFactory.bytes(namespace.getValue());
    }

    protected static byte[] bytes(UUID namespace) {
        return BinaryCodec.INSTANCE.encode(namespace);
    }

    protected static byte[] bytes(String namespace) {
        return BinaryCodec.INSTANCE.encode(StringCodec.INSTANCE.decode(namespace));
    }

    private UUID create(byte[] namespace, byte[] name) {
        MessageDigest hasher;
        try {
            hasher = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Message digest algorithm not available: " + this.algorithm, e);
        }
        if (namespace != null) {
            hasher.update(namespace);
        }
        byte[] hash = hasher.digest(name);
        long msb = ByteUtil.toNumber(hash, 0, 8);
        long lsb = ByteUtil.toNumber(hash, 8, 16);
        return this.toUuid(msb, lsb);
    }
}

