/*
 * Decompiled with CFR 0.152.
 */
package redis;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.dispatch.MessageDispatcher;
import java.io.Serializable;
import java.net.InetSocketAddress;
import redis.ActorRequest;
import redis.BufferedRequest;
import redis.ByteStringDeserializer;
import redis.ByteStringSerializer;
import redis.ByteStringSerializer$;
import redis.Cursor;
import redis.Operation;
import redis.Redis$;
import redis.RedisClientActorLike$;
import redis.RedisCommand;
import redis.RedisCommands;
import redis.RedisDispatcher;
import redis.RedisReplyDeserializer;
import redis.actors.RedisClientActor$;
import redis.api.Aggregate;
import redis.api.BitOperator;
import redis.api.Limit;
import redis.api.LimitOffsetCount;
import redis.api.ListPivot;
import redis.api.Order;
import redis.api.ShutdownModifier;
import redis.api.ZaddOption;
import redis.api.clusters.ClusterNodeInfo;
import redis.api.clusters.ClusterSlot;
import redis.api.geo.DistUnits;
import redis.api.geo.GeoOptions;
import redis.api.scripting.RedisScript;
import redis.commands.Clusters;
import redis.commands.Connection;
import redis.commands.Geo;
import redis.commands.Hashes;
import redis.commands.HyperLogLog;
import redis.commands.Keys;
import redis.commands.Lists;
import redis.commands.Publish;
import redis.commands.Scripting;
import redis.commands.Server;
import redis.commands.Sets;
import redis.commands.SortedSets;
import redis.commands.Strings;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Me!B\u000f\u001f\u0003\u0003\t\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0017\u0002\u0001\rQ\"\u0001M\u0011\u001dA\u0006\u00011A\u0007\u0002eCqa\u0018\u0001A\u0002\u001b\u0005\u0001\rC\u0004e\u0001\u0001\u0007i\u0011A3\t\u000f\u001d\u0004!\u0019!D\u0001\u0019\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB6\u0001A\u0003%!\u000eC\u0004m\u0001\t\u0007I\u0011A7\t\r=\u0004\u0001\u0015!\u0003o\u0011\u001d\u0001\bA1A\u0005\u0004EDa\u0001\u001f\u0001!\u0002\u0013\u0011\bbB=\u0001\u0005\u0004%\tA\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B>\t\r}\u0004A\u0011AA\u0001\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007;\u0011\"!\"\u001f\u0003\u0003E\t!a\"\u0007\u0011uq\u0012\u0011!E\u0001\u0003\u0013Ca!\u0012\u000e\u0005\u0002\u0005-\u0005\"CAG5E\u0005I\u0011AAH\u0005Q\u0011V\rZ5t\u00072LWM\u001c;BGR|'\u000fT5lK*\tq$A\u0003sK\u0012L7o\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011AH\u0005\u0003Wy\u0011A\"Q2u_J\u0014V-];fgR\faa]=ti\u0016l\u0007C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0015\t7\r^8s\u0015\u0005\u0011\u0014\u0001B1lW\u0006L!\u0001N\u0018\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0010e\u0016$\u0017n\u001d#jgB\fGo\u00195feB\u0011\u0011fN\u0005\u0003qy\u0011qBU3eSN$\u0015n\u001d9bi\u000eDWM]\u0001\u000fG>tg.Z2u)&lWm\\;u!\r\u00193(P\u0005\u0003y\u0011\u0012aa\u00149uS>t\u0007C\u0001 D\u001b\u0005y$B\u0001!B\u0003!!WO]1uS>t'B\u0001\"%\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\t~\u0012aBR5oSR,G)\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005\u000f\"K%\n\u0005\u0002*\u0001!)A\u0006\u0002a\u0001[!)Q\u0007\u0002a\u0001m!9\u0011\b\u0002I\u0001\u0002\u0004Q\u0014\u0001\u00025pgR,\u0012!\u0014\t\u0003\u001dVs!aT*\u0011\u0005A#S\"A)\u000b\u0005I\u0003\u0013A\u0002\u001fs_>$h(\u0003\u0002UI\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!F%\u0001\u0005i_N$x\fJ3r)\tQV\f\u0005\u0002$7&\u0011A\f\n\u0002\u0005+:LG\u000fC\u0004_\r\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'\u0001\u0003q_J$X#A1\u0011\u0005\r\u0012\u0017BA2%\u0005\rIe\u000e^\u0001\ta>\u0014Ho\u0018\u0013fcR\u0011!L\u001a\u0005\b=\"\t\t\u00111\u0001b\u0003\u0011q\u0017-\\3\u0002\u0011A\f7o]<pe\u0012,\u0012A\u001b\t\u0004Gmj\u0015!\u00039bgN<xN\u001d3!\u0003\t!'-F\u0001o!\r\u00193(Y\u0001\u0004I\n\u0004\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005\u0011\bCA:w\u001b\u0005!(BA;2\u0003!!\u0017n\u001d9bi\u000eD\u0017BA<u\u0005EiUm]:bO\u0016$\u0015n\u001d9bi\u000eDWM]\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013a\u0004:fI&\u001c8i\u001c8oK\u000e$\u0018n\u001c8\u0016\u0003m\u0004\"A\f?\n\u0005u|#\u0001C!di>\u0014(+\u001a4\u0002!I,G-[:D_:tWm\u0019;j_:\u0004\u0013!\u0003:fG>tg.Z2u)\u0015Q\u00161AA\u0003\u0011\u001dY%\u0003%AA\u00025Cqa\u0018\n\u0011\u0002\u0003\u0007\u0011-A\nsK\u000e|gN\\3di\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\f)\u001aQ*!\u0004,\u0005\u0005=\u0001\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0007%\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\t\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1C]3d_:tWm\u0019;%I\u00164\u0017-\u001e7uII*\"!a\t+\u0007\u0005\fi!A\u0005p]\u000e{gN\\3diR\u0019!,!\u000b\t\r})\u0002\u0019AA\u0016!\rI\u0013QF\u0005\u0004\u0003_q\"!\u0004*fI&\u001c8i\\7nC:$7/A\bp]\u000e{gN\\3diN#\u0018\r^;t+\t\t)\u0004\u0005\u0004$\u0003o\tYDW\u0005\u0004\u0003s!#!\u0003$v]\u000e$\u0018n\u001c82!\r\u0019\u0013QH\u0005\u0004\u0003\u007f!#a\u0002\"p_2,\u0017M\\\u0001\u0015O\u0016$8i\u001c8oK\u000e$x\n]3sCRLwN\\:\u0016\u0005\u0005\u0015\u0003#B\u0012\u0002H\u0005-\u0013bAA%I\tIa)\u001e8di&|g\u000e\r\t\u0007\u0003\u001b\n9&!\u0018\u000f\t\u0005=\u00131\u000b\b\u0004!\u0006E\u0013\"A\u0013\n\u0007\u0005UC%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\u0004'\u0016\f(bAA+IA2\u0011qLA5\u0003{\u0002r!KA1\u0003K\nY(C\u0002\u0002dy\u0011\u0011b\u00149fe\u0006$\u0018n\u001c8\u0011\t\u0005\u001d\u0014\u0011\u000e\u0007\u0001\t-\tYgFA\u0001\u0002\u0003\u0015\t!!\u001c\u0003\u0007}#\u0013'\u0005\u0003\u0002p\u0005U\u0004cA\u0012\u0002r%\u0019\u00111\u000f\u0013\u0003\u000f9{G\u000f[5oOB\u00191%a\u001e\n\u0007\u0005eDEA\u0002B]f\u0004B!a\u001a\u0002~\u0011Y\u0011qP\f\u0002\u0002\u0003\u0005)\u0011AA7\u0005\ryFEM\u0001\u0005gR|\u0007\u000fF\u0001[\u0003Q\u0011V\rZ5t\u00072LWM\u001c;BGR|'\u000fT5lKB\u0011\u0011FG\n\u00035\t\"\"!a\"\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tJK\u0002;\u0003\u001b\u0001")
public abstract class RedisClientActorLike
implements ActorRequest {
    private final ActorSystem system;
    private final Option<String> password;
    private final Option<Object> db;
    private final MessageDispatcher executionContext;
    private final ActorRef redisConnection;

    public static Option<FiniteDuration> $lessinit$greater$default$3() {
        return RedisClientActorLike$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public <T> Future<T> send(RedisCommand<? extends RedisReply, T> redisCommand) {
        return ActorRequest.send$(this, redisCommand);
    }

    public abstract String host();

    public abstract void host_$eq(String var1);

    public abstract int port();

    public abstract void port_$eq(int var1);

    public abstract String name();

    public Option<String> password() {
        return this.password;
    }

    public Option<Object> db() {
        return this.db;
    }

    public MessageDispatcher executionContext() {
        return this.executionContext;
    }

    @Override
    public ActorRef redisConnection() {
        return this.redisConnection;
    }

    public void reconnect(String host, int port) {
        block0: {
            String string = this.host();
            String string2 = host;
            if (!(string != null ? !string.equals(string2) : string2 != null) && this.port() == port) break block0;
            this.host_$eq(host);
            this.port_$eq(port);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.redisConnection());
            InetSocketAddress x$1 = new InetSocketAddress(host, port);
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    public String reconnect$default$1() {
        return this.host();
    }

    public int reconnect$default$2() {
        return this.port();
    }

    public void onConnect(RedisCommands redis) {
        this.password().foreach((Function1 & Serializable)x$1 -> redis.auth(x$1, ByteStringSerializer$.MODULE$.String()));
        this.db().foreach((Function1 & Serializable)x$2 -> redis.select(BoxesRunTime.unboxToInt((Object)x$2)));
    }

    public Function1<Object, BoxedUnit> onConnectStatus() {
        return (Function1 & Serializable)status -> {
            RedisClientActorLike.$anonfun$onConnectStatus$1(BoxesRunTime.unboxToBoolean((Object)status));
            return BoxedUnit.UNIT;
        };
    }

    public Function0<Seq<Operation<?, ?>>> getConnectOperations() {
        return (Function0 & Serializable)() -> {
            RedisClientActorLike self = this;
            BufferedRequest redis = new BufferedRequest(null, self){
                private final ExecutionContext executionContext;
                private Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations;

                public <K> Future<Object> geoAdd(String key, double lat, double lng, String loc) {
                    return Geo.geoAdd$(this, key, lat, lng, loc);
                }

                public <K> Future<Seq<String>> geoRadius(String key, double lat, double lng, double radius, DistUnits.Measurement dim) {
                    return Geo.geoRadius$(this, key, lat, lng, radius, dim);
                }

                public <K> DistUnits.Measurement geoRadius$default$5() {
                    return Geo.geoRadius$default$5$(this);
                }

                public <K> Future<Seq<String>> geoRadiusByMember(String key, String member, int dist, DistUnits.Measurement dim) {
                    return Geo.geoRadiusByMember$(this, key, member, dist, dim);
                }

                public <K> DistUnits.Measurement geoRadiusByMember$default$4() {
                    return Geo.geoRadiusByMember$default$4$(this);
                }

                public <K> Future<Seq<String>> geoRadiusByMemberWithOpt(String key, String member, int dist, DistUnits.Measurement dim, GeoOptions.WithOption opt, int count) {
                    return Geo.geoRadiusByMemberWithOpt$(this, key, member, dist, dim, opt, count);
                }

                public <K> DistUnits.Measurement geoRadiusByMemberWithOpt$default$4() {
                    return Geo.geoRadiusByMemberWithOpt$default$4$(this);
                }

                public <K> GeoOptions.WithOption geoRadiusByMemberWithOpt$default$5() {
                    return Geo.geoRadiusByMemberWithOpt$default$5$(this);
                }

                public <K> int geoRadiusByMemberWithOpt$default$6() {
                    return Geo.geoRadiusByMemberWithOpt$default$6$(this);
                }

                public <K> Future<Object> geoDist(String key, String member1, String member2, DistUnits.Measurement unit) {
                    return Geo.geoDist$(this, key, member1, member2, unit);
                }

                public <K> DistUnits.Measurement geoDist$default$4() {
                    return Geo.geoDist$default$4$(this);
                }

                public <K> Future<Seq<String>> geoHash(String key, Seq<String> members) {
                    return Geo.geoHash$(this, key, members);
                }

                public <K> Future<Seq<String>> geoPos(String key, Seq<String> members) {
                    return Geo.geoPos$(this, key, members);
                }

                public Future<Seq<ClusterSlot>> clusterSlots() {
                    return Clusters.clusterSlots$(this);
                }

                public Future<Map<String, String>> clusterInfo() {
                    return Clusters.clusterInfo$(this);
                }

                public Future<ClusterNodeInfo[]> clusterNodes() {
                    return Clusters.clusterNodes$(this);
                }

                public <V> Future<Object> pfadd(String key, Seq<V> values, ByteStringSerializer<V> evidence$1) {
                    return HyperLogLog.pfadd$(this, key, values, evidence$1);
                }

                public Future<Object> pfcount(Seq<String> keys) {
                    return HyperLogLog.pfcount$(this, keys);
                }

                public Future<Object> pfmerge(String destKey, Seq<String> sourceKeys) {
                    return HyperLogLog.pfmerge$(this, destKey, sourceKeys);
                }

                public Future<String> bgrewriteaof() {
                    return Server.bgrewriteaof$(this);
                }

                public Future<String> bgsave() {
                    return Server.bgsave$(this);
                }

                public Future<Object> clientKill(String ip, int port) {
                    return Server.clientKill$(this, ip, port);
                }

                public Future<Seq<Map<String, String>>> clientList() {
                    return Server.clientList$(this);
                }

                public Future<Option<String>> clientGetname() {
                    return Server.clientGetname$(this);
                }

                public Future<Object> clientSetname(String connectionName) {
                    return Server.clientSetname$(this, connectionName);
                }

                public Future<Map<String, String>> configGet(String parameter) {
                    return Server.configGet$(this, parameter);
                }

                public Future<Object> configSet(String parameter, String value) {
                    return Server.configSet$(this, parameter, value);
                }

                public Future<Object> configResetstat() {
                    return Server.configResetstat$(this);
                }

                public Future<Object> dbsize() {
                    return Server.dbsize$(this);
                }

                public Future<String> debugObject(String key) {
                    return Server.debugObject$(this, key);
                }

                public Future<String> debugSegfault() {
                    return Server.debugSegfault$(this);
                }

                public Future<Object> flushall() {
                    return Server.flushall$(this);
                }

                public Future<Object> flushdb() {
                    return Server.flushdb$(this);
                }

                public Future<String> info() {
                    return Server.info$(this);
                }

                public Future<String> info(String section) {
                    return Server.info$(this, section);
                }

                public Future<Object> lastsave() {
                    return Server.lastsave$(this);
                }

                public Future<Object> save() {
                    return Server.save$(this);
                }

                public Future<Object> shutdown() {
                    return Server.shutdown$(this);
                }

                public Future<Object> shutdown(ShutdownModifier modifier) {
                    return Server.shutdown$(this, modifier);
                }

                public Future<Object> slaveof(String host, int port) {
                    return Server.slaveof$(this, host, port);
                }

                public Future<Object> slaveofNoOne() {
                    return Server.slaveofNoOne$(this);
                }

                public Future<Tuple2<Object, Object>> time() {
                    return Server.time$(this);
                }

                public <V> Future<Status> auth(V value, ByteStringSerializer<V> evidence$1) {
                    return Connection.auth$(this, value, evidence$1);
                }

                public <V, R> Future<Option<R>> echo(V value, ByteStringSerializer<V> evidence$2, ByteStringDeserializer<R> evidence$3) {
                    return Connection.echo$(this, value, evidence$2, evidence$3);
                }

                public Future<String> ping() {
                    return Connection.ping$(this);
                }

                public Future<Object> quit() {
                    return Connection.quit$(this);
                }

                public Future<Object> select(int index) {
                    return Connection.select$(this, index);
                }

                public <R> Future<R> evalshaOrEval(RedisScript redisScript, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$1) {
                    return Scripting.evalshaOrEval$(this, redisScript, keys, args, evidence$1);
                }

                public <R> Seq<String> evalshaOrEval$default$2() {
                    return Scripting.evalshaOrEval$default$2$(this);
                }

                public <R> Seq<String> evalshaOrEval$default$3() {
                    return Scripting.evalshaOrEval$default$3$(this);
                }

                public <R> Future<R> eval(String script, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$2) {
                    return Scripting.eval$(this, script, keys, args, evidence$2);
                }

                public <R> Seq<String> eval$default$2() {
                    return Scripting.eval$default$2$(this);
                }

                public <R> Seq<String> eval$default$3() {
                    return Scripting.eval$default$3$(this);
                }

                public <R> Future<R> evalsha(String sha1, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$3) {
                    return Scripting.evalsha$(this, sha1, keys, args, evidence$3);
                }

                public <R> Seq<String> evalsha$default$2() {
                    return Scripting.evalsha$default$2$(this);
                }

                public <R> Seq<String> evalsha$default$3() {
                    return Scripting.evalsha$default$3$(this);
                }

                public Future<Object> scriptFlush() {
                    return Scripting.scriptFlush$(this);
                }

                public Future<Object> scriptKill() {
                    return Scripting.scriptKill$(this);
                }

                public Future<String> scriptLoad(String script) {
                    return Scripting.scriptLoad$(this, script);
                }

                public Future<Seq<Object>> scriptExists(Seq<String> sha1) {
                    return Scripting.scriptExists$(this, sha1);
                }

                public <V> Future<Object> publish(String channel, V value, ByteStringSerializer<V> evidence$1) {
                    return Publish.publish$(this, channel, value, evidence$1);
                }

                public <V> Future<Object> zadd(String key, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$1) {
                    return SortedSets.zadd$(this, key, scoreMembers, evidence$1);
                }

                public <V> Future<Object> zaddWithOptions(String key, Seq<ZaddOption> options, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$2) {
                    return SortedSets.zaddWithOptions$(this, key, options, scoreMembers, evidence$2);
                }

                public Future<Object> zcard(String key) {
                    return SortedSets.zcard$(this, key);
                }

                public Future<Object> zcount(String key, Limit min, Limit max) {
                    return SortedSets.zcount$(this, key, min, max);
                }

                public Limit zcount$default$2() {
                    return SortedSets.zcount$default$2$(this);
                }

                public Limit zcount$default$3() {
                    return SortedSets.zcount$default$3$(this);
                }

                public <V> Future<Object> zincrby(String key, double increment, V member, ByteStringSerializer<V> evidence$3) {
                    return SortedSets.zincrby$(this, key, increment, member, evidence$3);
                }

                public Future<Object> zinterstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                    return SortedSets.zinterstore$(this, destination, key, keys, aggregate);
                }

                public Aggregate zinterstore$default$4() {
                    return SortedSets.zinterstore$default$4$(this);
                }

                public Future<Object> zinterstoreWeighted(String destination, Map<String, Object> keys, Aggregate aggregate) {
                    return SortedSets.zinterstoreWeighted$(this, destination, keys, aggregate);
                }

                public Aggregate zinterstoreWeighted$default$3() {
                    return SortedSets.zinterstoreWeighted$default$3$(this);
                }

                public <R> Future<Seq<R>> zrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$4) {
                    return SortedSets.zrange$(this, key, start, stop, evidence$4);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrangeWithscores(String key, long start, long stop, ByteStringDeserializer<R> evidence$5) {
                    return SortedSets.zrangeWithscores$(this, key, start, stop, evidence$5);
                }

                public <R> Future<Seq<R>> zrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$6) {
                    return SortedSets.zrangebyscore$(this, key, min, max, limit, evidence$6);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebyscore$default$4() {
                    return SortedSets.zrangebyscore$default$4$(this);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$7) {
                    return SortedSets.zrangebyscoreWithscores$(this, key, min, max, limit, evidence$7);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebyscoreWithscores$default$4() {
                    return SortedSets.zrangebyscoreWithscores$default$4$(this);
                }

                public <V> Future<Option<Object>> zrank(String key, V member, ByteStringSerializer<V> evidence$8) {
                    return SortedSets.zrank$(this, key, member, evidence$8);
                }

                public <V> Future<Object> zrem(String key, Seq<V> members, ByteStringSerializer<V> evidence$9) {
                    return SortedSets.zrem$(this, key, members, evidence$9);
                }

                public Future<Object> zremrangebylex(String key, String min, String max) {
                    return SortedSets.zremrangebylex$(this, key, min, max);
                }

                public Future<Object> zremrangebyrank(String key, long start, long stop) {
                    return SortedSets.zremrangebyrank$(this, key, start, stop);
                }

                public Future<Object> zremrangebyscore(String key, Limit min, Limit max) {
                    return SortedSets.zremrangebyscore$(this, key, min, max);
                }

                public <R> Future<Seq<R>> zrevrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$10) {
                    return SortedSets.zrevrange$(this, key, start, stop, evidence$10);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrevrangeWithscores(String key, long start, long stop, ByteStringDeserializer<R> evidence$11) {
                    return SortedSets.zrevrangeWithscores$(this, key, start, stop, evidence$11);
                }

                public <R> Future<Seq<R>> zrevrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$12) {
                    return SortedSets.zrevrangebyscore$(this, key, min, max, limit, evidence$12);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebyscore$default$4() {
                    return SortedSets.zrevrangebyscore$default$4$(this);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrevrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$13) {
                    return SortedSets.zrevrangebyscoreWithscores$(this, key, min, max, limit, evidence$13);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebyscoreWithscores$default$4() {
                    return SortedSets.zrevrangebyscoreWithscores$default$4$(this);
                }

                public <V> Future<Option<Object>> zrevrank(String key, V member, ByteStringSerializer<V> evidence$14) {
                    return SortedSets.zrevrank$(this, key, member, evidence$14);
                }

                public <V> Future<Option<Object>> zscore(String key, V member, ByteStringSerializer<V> evidence$15) {
                    return SortedSets.zscore$(this, key, member, evidence$15);
                }

                public Future<Object> zunionstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                    return SortedSets.zunionstore$(this, destination, key, keys, aggregate);
                }

                public Aggregate zunionstore$default$4() {
                    return SortedSets.zunionstore$default$4$(this);
                }

                public Future<Object> zunionstoreWeighted(String destination, Map<String, Object> keys, Aggregate aggregate) {
                    return SortedSets.zunionstoreWeighted$(this, destination, keys, aggregate);
                }

                public Aggregate zunionstoreWeighted$default$3() {
                    return SortedSets.zunionstoreWeighted$default$3$(this);
                }

                public <R> Future<Seq<R>> zrangebylex(String key, Option<String> min, Option<String> max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$16) {
                    return SortedSets.zrangebylex$(this, key, min, max, limit, evidence$16);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebylex$default$4() {
                    return SortedSets.zrangebylex$default$4$(this);
                }

                public <R> Future<Seq<R>> zrevrangebylex(String key, Option<String> max, Option<String> min, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$17) {
                    return SortedSets.zrevrangebylex$(this, key, max, min, limit, evidence$17);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebylex$default$4() {
                    return SortedSets.zrevrangebylex$default$4$(this);
                }

                public <R> Future<Cursor<Seq<Tuple2<Object, R>>>> zscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$18) {
                    return SortedSets.zscan$(this, key, cursor, count, matchGlob, evidence$18);
                }

                public <R> int zscan$default$2() {
                    return SortedSets.zscan$default$2$(this);
                }

                public <R> Option<Object> zscan$default$3() {
                    return SortedSets.zscan$default$3$(this);
                }

                public <R> Option<String> zscan$default$4() {
                    return SortedSets.zscan$default$4$(this);
                }

                public <V> Future<Object> sadd(String key, Seq<V> members, ByteStringSerializer<V> evidence$1) {
                    return Sets.sadd$(this, key, members, evidence$1);
                }

                public Future<Object> scard(String key) {
                    return Sets.scard$(this, key);
                }

                public <R> Future<Seq<R>> sdiff(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$2) {
                    return Sets.sdiff$(this, key, keys, evidence$2);
                }

                public Future<Object> sdiffstore(String destination, String key, Seq<String> keys) {
                    return Sets.sdiffstore$(this, destination, key, keys);
                }

                public <R> Future<Seq<R>> sinter(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$3) {
                    return Sets.sinter$(this, key, keys, evidence$3);
                }

                public Future<Object> sinterstore(String destination, String key, Seq<String> keys) {
                    return Sets.sinterstore$(this, destination, key, keys);
                }

                public <V> Future<Object> sismember(String key, V member, ByteStringSerializer<V> evidence$4) {
                    return Sets.sismember$(this, key, member, evidence$4);
                }

                public <R> Future<Seq<R>> smembers(String key, ByteStringDeserializer<R> evidence$5) {
                    return Sets.smembers$(this, key, evidence$5);
                }

                public <V> Future<Object> smove(String source, String destination, V member, ByteStringSerializer<V> evidence$6) {
                    return Sets.smove$(this, source, destination, member, evidence$6);
                }

                public <R> Future<Option<R>> spop(String key, ByteStringDeserializer<R> evidence$7) {
                    return Sets.spop$(this, key, evidence$7);
                }

                public <R> Future<Option<R>> srandmember(String key, ByteStringDeserializer<R> evidence$8) {
                    return Sets.srandmember$(this, key, evidence$8);
                }

                public <R> Future<Seq<R>> srandmember(String key, long count, ByteStringDeserializer<R> evidence$9) {
                    return Sets.srandmember$(this, key, count, evidence$9);
                }

                public <V> Future<Object> srem(String key, Seq<V> members, ByteStringSerializer<V> evidence$10) {
                    return Sets.srem$(this, key, members, evidence$10);
                }

                public <R> Future<Seq<R>> sunion(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$11) {
                    return Sets.sunion$(this, key, keys, evidence$11);
                }

                public Future<Object> sunionstore(String destination, String key, Seq<String> keys) {
                    return Sets.sunionstore$(this, destination, key, keys);
                }

                public <R> Future<Cursor<Seq<R>>> sscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$12) {
                    return Sets.sscan$(this, key, cursor, count, matchGlob, evidence$12);
                }

                public <R> int sscan$default$2() {
                    return Sets.sscan$default$2$(this);
                }

                public <R> Option<Object> sscan$default$3() {
                    return Sets.sscan$default$3$(this);
                }

                public <R> Option<String> sscan$default$4() {
                    return Sets.sscan$default$4$(this);
                }

                public <R> Future<Option<R>> lindex(String key, long index, ByteStringDeserializer<R> evidence$1) {
                    return Lists.lindex$(this, key, index, evidence$1);
                }

                public <V> Future<Object> linsertAfter(String key, String pivot, V value, ByteStringSerializer<V> evidence$2) {
                    return Lists.linsertAfter$(this, key, pivot, value, evidence$2);
                }

                public <V> Future<Object> linsertBefore(String key, String pivot, V value, ByteStringSerializer<V> evidence$3) {
                    return Lists.linsertBefore$(this, key, pivot, value, evidence$3);
                }

                public <V> Future<Object> linsert(String key, ListPivot beforeAfter, String pivot, V value, ByteStringSerializer<V> evidence$4) {
                    return Lists.linsert$(this, key, beforeAfter, pivot, value, evidence$4);
                }

                public Future<Object> llen(String key) {
                    return Lists.llen$(this, key);
                }

                public <R> Future<Option<R>> lpop(String key, ByteStringDeserializer<R> evidence$5) {
                    return Lists.lpop$(this, key, evidence$5);
                }

                public <V> Future<Object> lpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$6) {
                    return Lists.lpush$(this, key, values, evidence$6);
                }

                public <V> Future<Object> lpushx(String key, V value, ByteStringSerializer<V> evidence$7) {
                    return Lists.lpushx$(this, key, value, evidence$7);
                }

                public <R> Future<Seq<R>> lrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$8) {
                    return Lists.lrange$(this, key, start, stop, evidence$8);
                }

                public <V> Future<Object> lrem(String key, long count, V value, ByteStringSerializer<V> evidence$9) {
                    return Lists.lrem$(this, key, count, value, evidence$9);
                }

                public <V> Future<Object> lset(String key, long index, V value, ByteStringSerializer<V> evidence$10) {
                    return Lists.lset$(this, key, index, value, evidence$10);
                }

                public Future<Object> ltrim(String key, long start, long stop) {
                    return Lists.ltrim$(this, key, start, stop);
                }

                public <R> Future<Option<R>> rpop(String key, ByteStringDeserializer<R> evidence$11) {
                    return Lists.rpop$(this, key, evidence$11);
                }

                public <R> Future<Option<R>> rpoplpush(String source, String destination, ByteStringDeserializer<R> evidence$12) {
                    return Lists.rpoplpush$(this, source, destination, evidence$12);
                }

                public <V> Future<Object> rpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$13) {
                    return Lists.rpush$(this, key, values, evidence$13);
                }

                public <V> Future<Object> rpushx(String key, V value, ByteStringSerializer<V> evidence$14) {
                    return Lists.rpushx$(this, key, value, evidence$14);
                }

                public Future<Object> hdel(String key, Seq<String> fields) {
                    return Hashes.hdel$(this, key, fields);
                }

                public Future<Object> hexists(String key, String field) {
                    return Hashes.hexists$(this, key, field);
                }

                public <R> Future<Option<R>> hget(String key, String field, ByteStringDeserializer<R> evidence$1) {
                    return Hashes.hget$(this, key, field, evidence$1);
                }

                public <R> Future<Map<String, R>> hgetall(String key, ByteStringDeserializer<R> evidence$2) {
                    return Hashes.hgetall$(this, key, evidence$2);
                }

                public Future<Object> hincrby(String key, String fields, long increment) {
                    return Hashes.hincrby$(this, key, fields, increment);
                }

                public Future<Object> hincrbyfloat(String key, String fields, double increment) {
                    return Hashes.hincrbyfloat$(this, key, fields, increment);
                }

                public Future<Seq<String>> hkeys(String key) {
                    return Hashes.hkeys$(this, key);
                }

                public Future<Object> hlen(String key) {
                    return Hashes.hlen$(this, key);
                }

                public <R> Future<Seq<Option<R>>> hmget(String key, Seq<String> fields, ByteStringDeserializer<R> evidence$3) {
                    return Hashes.hmget$(this, key, fields, evidence$3);
                }

                public <V> Future<Object> hmset(String key, Map<String, V> keysValues, ByteStringSerializer<V> evidence$4) {
                    return Hashes.hmset$(this, key, keysValues, evidence$4);
                }

                public <V> Future<Object> hset(String key, String field, V value, ByteStringSerializer<V> evidence$5) {
                    return Hashes.hset$(this, key, field, value, evidence$5);
                }

                public <V> Future<Object> hsetnx(String key, String field, V value, ByteStringSerializer<V> evidence$6) {
                    return Hashes.hsetnx$(this, key, field, value, evidence$6);
                }

                public <R> Future<Seq<R>> hvals(String key, ByteStringDeserializer<R> evidence$7) {
                    return Hashes.hvals$(this, key, evidence$7);
                }

                public <R> Future<Cursor<Map<String, R>>> hscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$8) {
                    return Hashes.hscan$(this, key, cursor, count, matchGlob, evidence$8);
                }

                public <R> int hscan$default$2() {
                    return Hashes.hscan$default$2$(this);
                }

                public <R> Option<Object> hscan$default$3() {
                    return Hashes.hscan$default$3$(this);
                }

                public <R> Option<String> hscan$default$4() {
                    return Hashes.hscan$default$4$(this);
                }

                public <V> Future<Object> append(String key, V value, ByteStringSerializer<V> evidence$1) {
                    return Strings.append$(this, key, value, evidence$1);
                }

                public Future<Object> bitcount(String key) {
                    return Strings.bitcount$(this, key);
                }

                public Future<Object> bitcount(String key, long start, long end) {
                    return Strings.bitcount$(this, key, start, end);
                }

                public Future<Object> bitopAND(String destkey, Seq<String> keys) {
                    return Strings.bitopAND$(this, destkey, keys);
                }

                public Future<Object> bitopOR(String destkey, Seq<String> keys) {
                    return Strings.bitopOR$(this, destkey, keys);
                }

                public Future<Object> bitopXOR(String destkey, Seq<String> keys) {
                    return Strings.bitopXOR$(this, destkey, keys);
                }

                public Future<Object> bitopNOT(String destkey, String key) {
                    return Strings.bitopNOT$(this, destkey, key);
                }

                public Future<Object> bitop(BitOperator operation, String destkey, Seq<String> keys) {
                    return Strings.bitop$(this, operation, destkey, keys);
                }

                public Future<Object> bitpos(String key, long bit, long start, long end) {
                    return Strings.bitpos$(this, key, bit, start, end);
                }

                public long bitpos$default$3() {
                    return Strings.bitpos$default$3$(this);
                }

                public long bitpos$default$4() {
                    return Strings.bitpos$default$4$(this);
                }

                public Future<Object> decr(String key) {
                    return Strings.decr$(this, key);
                }

                public Future<Object> decrby(String key, long decrement) {
                    return Strings.decrby$(this, key, decrement);
                }

                public <R> Future<Option<R>> get(String key, ByteStringDeserializer<R> evidence$2) {
                    return Strings.get$(this, key, evidence$2);
                }

                public Future<Object> getbit(String key, long offset) {
                    return Strings.getbit$(this, key, offset);
                }

                public <R> Future<Option<R>> getrange(String key, long start, long end, ByteStringDeserializer<R> evidence$3) {
                    return Strings.getrange$(this, key, start, end, evidence$3);
                }

                public <V, R> Future<Option<R>> getset(String key, V value, ByteStringSerializer<V> evidence$4, ByteStringDeserializer<R> evidence$5) {
                    return Strings.getset$(this, key, value, evidence$4, evidence$5);
                }

                public Future<Object> incr(String key) {
                    return Strings.incr$(this, key);
                }

                public Future<Object> incrby(String key, long increment) {
                    return Strings.incrby$(this, key, increment);
                }

                public Future<Option<Object>> incrbyfloat(String key, double increment) {
                    return Strings.incrbyfloat$(this, key, increment);
                }

                public <R> Future<Seq<Option<R>>> mget(Seq<String> keys, ByteStringDeserializer<R> evidence$6) {
                    return Strings.mget$(this, keys, evidence$6);
                }

                public <V> Future<Object> mset(Map<String, V> keysValues, ByteStringSerializer<V> evidence$7) {
                    return Strings.mset$(this, keysValues, evidence$7);
                }

                public <V> Future<Object> msetnx(Map<String, V> keysValues, ByteStringSerializer<V> evidence$8) {
                    return Strings.msetnx$(this, keysValues, evidence$8);
                }

                public <V> Future<Object> psetex(String key, long milliseconds, V value, ByteStringSerializer<V> evidence$9) {
                    return Strings.psetex$(this, key, milliseconds, value, evidence$9);
                }

                public <V> Future<Object> set(String key, V value, Option<Object> exSeconds, Option<Object> pxMilliseconds, boolean NX, boolean XX, ByteStringSerializer<V> evidence$10) {
                    return Strings.set$(this, key, value, exSeconds, pxMilliseconds, NX, XX, evidence$10);
                }

                public <V> Option<Object> set$default$3() {
                    return Strings.set$default$3$(this);
                }

                public <V> Option<Object> set$default$4() {
                    return Strings.set$default$4$(this);
                }

                public <V> boolean set$default$5() {
                    return Strings.set$default$5$(this);
                }

                public <V> boolean set$default$6() {
                    return Strings.set$default$6$(this);
                }

                public Future<Object> setbit(String key, long offset, boolean value) {
                    return Strings.setbit$(this, key, offset, value);
                }

                public <V> Future<Object> setex(String key, long seconds, V value, ByteStringSerializer<V> evidence$11) {
                    return Strings.setex$(this, key, seconds, value, evidence$11);
                }

                public <V> Future<Object> setnx(String key, V value, ByteStringSerializer<V> evidence$12) {
                    return Strings.setnx$(this, key, value, evidence$12);
                }

                public <V> Future<Object> setrange(String key, long offset, V value, ByteStringSerializer<V> evidence$13) {
                    return Strings.setrange$(this, key, offset, value, evidence$13);
                }

                public Future<Object> strlen(String key) {
                    return Strings.strlen$(this, key);
                }

                public Future<Object> del(Seq<String> keys) {
                    return Keys.del$(this, keys);
                }

                public <R> Future<Option<R>> dump(String key, ByteStringDeserializer<R> evidence$1) {
                    return Keys.dump$(this, key, evidence$1);
                }

                public Future<Object> exists(String key) {
                    return Keys.exists$(this, key);
                }

                public Future<Object> existsMany(Seq<String> keys) {
                    return Keys.existsMany$(this, keys);
                }

                public Future<Object> expire(String key, long seconds) {
                    return Keys.expire$(this, key, seconds);
                }

                public Future<Object> expireat(String key, long seconds) {
                    return Keys.expireat$(this, key, seconds);
                }

                public Future<Seq<String>> keys(String pattern) {
                    return Keys.keys$(this, pattern);
                }

                public Future<Object> migrate(String host, int port, String key, int destinationDB, FiniteDuration timeout) {
                    return Keys.migrate$(this, host, port, key, destinationDB, timeout);
                }

                public Future<Object> move(String key, int db) {
                    return Keys.move$(this, key, db);
                }

                public Future<Option<Object>> objectRefcount(String key) {
                    return Keys.objectRefcount$(this, key);
                }

                public Future<Option<Object>> objectIdletime(String key) {
                    return Keys.objectIdletime$(this, key);
                }

                public Future<Option<String>> objectEncoding(String key) {
                    return Keys.objectEncoding$(this, key);
                }

                public Future<Object> persist(String key) {
                    return Keys.persist$(this, key);
                }

                public Future<Object> pexpire(String key, long milliseconds) {
                    return Keys.pexpire$(this, key, milliseconds);
                }

                public Future<Object> pexpireat(String key, long millisecondsTimestamp) {
                    return Keys.pexpireat$(this, key, millisecondsTimestamp);
                }

                public Future<Object> pttl(String key) {
                    return Keys.pttl$(this, key);
                }

                public <R> Future<Option<R>> randomkey(ByteStringDeserializer<R> evidence$2) {
                    return Keys.randomkey$(this, evidence$2);
                }

                public Future<Object> rename(String key, String newkey) {
                    return Keys.rename$(this, key, newkey);
                }

                public Future<Object> renamenx(String key, String newkey) {
                    return Keys.renamenx$(this, key, newkey);
                }

                public <V> Future<Object> restore(String key, long ttl, V serializedValue, ByteStringSerializer<V> evidence$3) {
                    return Keys.restore$(this, key, ttl, serializedValue, evidence$3);
                }

                public <V> long restore$default$2() {
                    return Keys.restore$default$2$(this);
                }

                public <R> Future<Seq<R>> sort(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, ByteStringDeserializer<R> evidence$4) {
                    return Keys.sort$(this, key, byPattern, limit, getPatterns, order, alpha, evidence$4);
                }

                public <R> Option<String> sort$default$2() {
                    return Keys.sort$default$2$(this);
                }

                public <R> Option<LimitOffsetCount> sort$default$3() {
                    return Keys.sort$default$3$(this);
                }

                public <R> Seq<String> sort$default$4() {
                    return Keys.sort$default$4$(this);
                }

                public <R> Option<Order> sort$default$5() {
                    return Keys.sort$default$5$(this);
                }

                public <R> boolean sort$default$6() {
                    return Keys.sort$default$6$(this);
                }

                public Future<Object> sortStore(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, String store) {
                    return Keys.sortStore$(this, key, byPattern, limit, getPatterns, order, alpha, store);
                }

                public Option<String> sortStore$default$2() {
                    return Keys.sortStore$default$2$(this);
                }

                public Option<LimitOffsetCount> sortStore$default$3() {
                    return Keys.sortStore$default$3$(this);
                }

                public Seq<String> sortStore$default$4() {
                    return Keys.sortStore$default$4$(this);
                }

                public Option<Order> sortStore$default$5() {
                    return Keys.sortStore$default$5$(this);
                }

                public boolean sortStore$default$6() {
                    return Keys.sortStore$default$6$(this);
                }

                public Future<Object> ttl(String key) {
                    return Keys.ttl$(this, key);
                }

                public Future<String> type(String key) {
                    return Keys.type$(this, key);
                }

                public Future<Cursor<Seq<String>>> scan(int cursor, Option<Object> count, Option<String> matchGlob) {
                    return Keys.scan$(this, cursor, count, matchGlob);
                }

                public int scan$default$1() {
                    return Keys.scan$default$1$(this);
                }

                public Option<Object> scan$default$2() {
                    return Keys.scan$default$2$(this);
                }

                public Option<String> scan$default$3() {
                    return Keys.scan$default$3$(this);
                }

                public <T> Future<T> send(RedisCommand<? extends RedisReply, T> redisCommand) {
                    return BufferedRequest.send$(this, redisCommand);
                }

                public Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations() {
                    return this.operations;
                }

                public void redis$BufferedRequest$_setter_$operations_$eq(Builder<Operation<?, ?>, Queue<Operation<?, ?>>> x$1) {
                    this.operations = x$1;
                }

                public ExecutionContext executionContext() {
                    return this.executionContext;
                }
                {
                    BufferedRequest.$init$(this);
                    Keys.$init$(this);
                    Strings.$init$(this);
                    Hashes.$init$(this);
                    Lists.$init$(this);
                    Sets.$init$(this);
                    SortedSets.$init$(this);
                    Publish.$init$(this);
                    Scripting.$init$(this);
                    Connection.$init$(this);
                    Server.$init$(this);
                    HyperLogLog.$init$(this);
                    Clusters.$init$(this);
                    Geo.$init$(this);
                    this.executionContext = self$1.executionContext();
                    Statics.releaseFence();
                }
            };
            this.onConnect((RedisCommands)((Object)redis));
            return (Queue)redis.operations().result();
        };
    }

    public void stop() {
        this.system.stop(this.redisConnection());
    }

    public static final /* synthetic */ void $anonfun$onConnectStatus$1(boolean status) {
    }

    public RedisClientActorLike(ActorSystem system, RedisDispatcher redisDispatcher, Option<FiniteDuration> connectTimeout) {
        this.system = system;
        ActorRequest.$init$(this);
        this.password = None$.MODULE$;
        this.db = None$.MODULE$;
        this.executionContext = system.dispatchers().lookup(redisDispatcher.name());
        this.redisConnection = system.actorOf(RedisClientActor$.MODULE$.props(new InetSocketAddress(this.host(), this.port()), this.getConnectOperations(), this.onConnectStatus(), redisDispatcher.name(), connectTimeout).withDispatcher(redisDispatcher.name()), new StringBuilder(0).append(this.name()).append('-').append(Redis$.MODULE$.tempName()).toString());
    }
}

