/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.SchemaClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/erosb/jsonsKema/ClassPathAwareSchemaClient;", "Lcom/github/erosb/jsonsKema/SchemaClient;", "fallbackClient", "<init>", "(Lcom/github/erosb/jsonsKema/SchemaClient;)V", "get", "Ljava/io/InputStream;", "url", "Ljava/net/URI;", "loadFromClasspath", "str", "", "handleProtocol", "Ljava/util/Optional;", "Companion", "json-sKema"})
public final class ClassPathAwareSchemaClient
implements SchemaClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchemaClient fallbackClient;
    @NotNull
    private static final List<String> HANDLED_PREFIXES;

    public ClassPathAwareSchemaClient(@NotNull SchemaClient fallbackClient) {
        Intrinsics.checkNotNullParameter((Object)fallbackClient, (String)"fallbackClient");
        this.fallbackClient = fallbackClient;
    }

    @Override
    @NotNull
    public InputStream get(@NotNull URI url) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Optional<String> maybeString = this.handleProtocol(string);
        if (maybeString.isPresent()) {
            String string2 = maybeString.get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
            InputStream stream = this.loadFromClasspath(string2);
            inputStream = stream;
            if (inputStream == null) {
                String string3 = "Could not find %s";
                Object[] objectArray = new Object[]{url};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                throw new UncheckedIOException(new IOException(string4));
            }
        } else {
            inputStream = this.fallbackClient.get(url);
        }
        return inputStream;
    }

    private final InputStream loadFromClasspath(String str) {
        return this.getClass().getResourceAsStream(str);
    }

    private final Optional<String> handleProtocol(String url) {
        Optional<String> optional = HANDLED_PREFIXES.stream().filter(arg_0 -> ClassPathAwareSchemaClient.handleProtocol$lambda$1(arg_0 -> ClassPathAwareSchemaClient.handleProtocol$lambda$0(url, arg_0), arg_0)).map(arg_0 -> ClassPathAwareSchemaClient.handleProtocol$lambda$3(arg_0 -> ClassPathAwareSchemaClient.handleProtocol$lambda$2(url, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        return optional;
    }

    @Override
    @NotNull
    public IJsonValue getParsed(@NotNull URI uri) {
        return SchemaClient.DefaultImpls.getParsed(this, uri);
    }

    private static final boolean handleProtocol$lambda$0(String $url, String prefix) {
        String string = prefix;
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.startsWith$default((String)$url, (String)string, (boolean)false, (int)2, null);
    }

    private static final boolean handleProtocol$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String handleProtocol$lambda$2(String $url, String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = $url.substring(prefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return stringBuilder.append(string).toString();
    }

    private static final String handleProtocol$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"classpath://", "classpath:/", "classpath:"};
        HANDLED_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/erosb/jsonsKema/ClassPathAwareSchemaClient$Companion;", "", "<init>", "()V", "HANDLED_PREFIXES", "", "", "json-sKema"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

