/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="webpack", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class WebpackMojo
extends AbstractFrontendMojo {
    @Parameter(property="frontend.webpack.arguments")
    private String arguments;
    @Parameter(property="triggerfiles")
    private List<File> triggerfiles;
    @Parameter(property="srcdir")
    private File srcdir;
    @Parameter(property="outputdir")
    private File outputdir;
    @Parameter(property="skip.webpack", defaultValue="${skip.webpack}")
    private boolean skip;
    @Component
    private BuildContext buildContext;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws TaskRunnerException {
        if (this.shouldExecute()) {
            factory.getWebpackRunner().execute(this.arguments, this.environmentVariables);
            if (this.outputdir != null) {
                this.getLog().info((CharSequence)("Refreshing files after webpack: " + this.outputdir));
                this.buildContext.refresh(this.outputdir);
            }
        } else {
            this.getLog().info((CharSequence)("Skipping webpack as no modified files in " + this.srcdir));
        }
    }

    private boolean shouldExecute() {
        if (this.triggerfiles == null || this.triggerfiles.isEmpty()) {
            this.triggerfiles = Arrays.asList(new File(this.workingDirectory, "webpack.config.js"));
        }
        return MojoUtils.shouldExecute(this.buildContext, this.triggerfiles, this.srcdir);
    }
}

