/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.concurrent.DefaultThreadFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.function.Callback;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.function.Decorator;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.io.CloseMode;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.AbstractIOReactorBase;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOReactorConfig;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOReactorStatus;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOReactorWorker;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOSession;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOSessionListener;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.IOWorkers;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.MultiCoreIOReactor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.reactor.SingleCoreIOReactor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.TimeValue;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;

public class DefaultConnectingIOReactor
extends AbstractIOReactorBase {
    private final int workerCount;
    private final SingleCoreIOReactor[] workers;
    private final MultiCoreIOReactor ioReactor;
    private final IOWorkers.Selector workerSelector;
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory("I/O client dispatch", true);

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, ThreadFactory threadFactory, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback) {
        Args.notNull(eventHandlerFactory, "Event handler factory");
        this.workerCount = ioReactorConfig != null ? ioReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.workers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threads = new Thread[this.workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            SingleCoreIOReactor dispatcher;
            this.workers[i] = dispatcher = new SingleCoreIOReactor(exceptionCallback, eventHandlerFactory, ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT, ioSessionDecorator, sessionListener, sessionShutdownCallback);
            threads[i] = (threadFactory != null ? threadFactory : THREAD_FACTORY).newThread(new IOReactorWorker(dispatcher));
        }
        this.ioReactor = new MultiCoreIOReactor(this.workers, threads);
        this.workerSelector = IOWorkers.newSelector(this.workers);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig config, Callback<IOSession> sessionShutdownCallback) {
        this(eventHandlerFactory, config, null, null, null, null, sessionShutdownCallback);
    }

    public DefaultConnectingIOReactor(IOEventHandlerFactory eventHandlerFactory) {
        this(eventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    IOWorkers.Selector getWorkerSelector() {
        return this.workerSelector;
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

