/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import java.lang.reflect.Method;
import org.socialsignin.spring.data.dynamodb.repository.EnableScan;
import org.socialsignin.spring.data.dynamodb.repository.EnableScanCount;
import org.socialsignin.spring.data.dynamodb.repository.support.EnableScanPermissions;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ReflectionUtils;

public class EnableScanAnnotationPermissions
implements EnableScanPermissions {
    private boolean findAllUnpaginatedScanEnabled = false;
    private boolean findAllPaginatedScanEnabled = false;
    private boolean findAllUnpaginatedScanCountEnabled = false;
    private boolean countUnpaginatedScanEnabled = false;
    private boolean deleteAllUnpaginatedScanEnabled = false;

    public EnableScanAnnotationPermissions(Class<?> repositoryInterface) {
        if (repositoryInterface.isAnnotationPresent(EnableScan.class)) {
            this.findAllUnpaginatedScanEnabled = true;
            this.countUnpaginatedScanEnabled = true;
            this.deleteAllUnpaginatedScanEnabled = true;
            this.findAllPaginatedScanEnabled = true;
        } else {
            Method[] methods;
            for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(repositoryInterface)) {
                if (!method.isAnnotationPresent(EnableScan.class) || method.getParameterTypes().length > 0) continue;
                if (method.getName().equals("findAll")) {
                    this.findAllUnpaginatedScanEnabled = true;
                    continue;
                }
                if (method.getName().equals("deleteAll")) {
                    this.deleteAllUnpaginatedScanEnabled = true;
                    continue;
                }
                if (!method.getName().equals("count")) continue;
                this.countUnpaginatedScanEnabled = true;
            }
            for (Method method : methods) {
                if (!method.isAnnotationPresent(EnableScanCount.class) || method.getParameterTypes().length != 1 || !method.getName().equals("findAll") || !Pageable.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                this.findAllUnpaginatedScanCountEnabled = true;
            }
            for (Method method : methods) {
                if (!method.isAnnotationPresent(EnableScan.class) || method.getParameterTypes().length != 1 || !method.getName().equals("findAll") || !Pageable.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
                this.findAllPaginatedScanEnabled = true;
            }
        }
        if (!this.findAllUnpaginatedScanCountEnabled && repositoryInterface.isAnnotationPresent(EnableScanCount.class)) {
            this.findAllUnpaginatedScanCountEnabled = true;
        }
    }

    @Override
    public boolean isFindAllUnpaginatedScanEnabled() {
        return this.findAllUnpaginatedScanEnabled;
    }

    @Override
    public boolean isDeleteAllUnpaginatedScanEnabled() {
        return this.deleteAllUnpaginatedScanEnabled;
    }

    @Override
    public boolean isCountUnpaginatedScanEnabled() {
        return this.countUnpaginatedScanEnabled;
    }

    @Override
    public boolean isFindAllUnpaginatedScanCountEnabled() {
        return this.findAllUnpaginatedScanCountEnabled;
    }

    @Override
    public boolean isFindAllPaginatedScanEnabled() {
        return this.findAllPaginatedScanEnabled;
    }
}

