/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.core;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.KeyPair;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterLoadEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterQueryEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterScanEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.DynamoDBMappingEvent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DynamoDBTemplate
implements DynamoDBOperations,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBTemplate.class);
    private final DynamoDBMapper dynamoDBMapper;
    private final AmazonDynamoDB amazonDynamoDB;
    private final DynamoDBMapperConfig dynamoDBMapperConfig;
    private ApplicationEventPublisher eventPublisher;

    @Autowired
    public DynamoDBTemplate(AmazonDynamoDB amazonDynamoDB, DynamoDBMapper dynamoDBMapper, DynamoDBMapperConfig dynamoDBMapperConfig) {
        Assert.notNull((Object)amazonDynamoDB, (String)"amazonDynamoDB must not be null!");
        Assert.notNull((Object)dynamoDBMapper, (String)"dynamoDBMapper must not be null!");
        Assert.notNull((Object)dynamoDBMapperConfig, (String)"dynamoDBMapperConfig must not be null!");
        this.amazonDynamoDB = amazonDynamoDB;
        this.dynamoDBMapper = dynamoDBMapper;
        this.dynamoDBMapperConfig = dynamoDBMapperConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.eventPublisher = applicationContext;
    }

    @Override
    public <T> int count(Class<T> domainClass, DynamoDBQueryExpression<T> queryExpression) {
        return this.dynamoDBMapper.count(domainClass, queryExpression);
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> domainClass, DynamoDBQueryExpression<T> queryExpression) {
        PaginatedQueryList results = this.dynamoDBMapper.query(domainClass, queryExpression);
        this.maybeEmitEvent(results, AfterQueryEvent::new);
        return results;
    }

    @Override
    public <T> int count(Class<T> domainClass, DynamoDBScanExpression scanExpression) {
        return this.dynamoDBMapper.count(domainClass, scanExpression);
    }

    @Override
    public <T> T load(Class<T> domainClass, Object hashKey, Object rangeKey) {
        Object entity = this.dynamoDBMapper.load(domainClass, hashKey, rangeKey);
        this.maybeEmitEvent(entity, AfterLoadEvent::new);
        return (T)entity;
    }

    @Override
    public <T> T load(Class<T> domainClass, Object hashKey) {
        Object entity = this.dynamoDBMapper.load(domainClass, hashKey);
        this.maybeEmitEvent(entity, AfterLoadEvent::new);
        return (T)entity;
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> domainClass, DynamoDBScanExpression scanExpression) {
        PaginatedScanList results = this.dynamoDBMapper.scan(domainClass, scanExpression);
        this.maybeEmitEvent(results, AfterScanEvent::new);
        return results;
    }

    @Override
    public <T> List<T> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet) {
        return this.dynamoDBMapper.batchLoad(itemsToGet).values().stream().flatMap(v -> v.stream()).map(e -> e).map(entity -> {
            this.maybeEmitEvent(entity, AfterLoadEvent::new);
            return entity;
        }).collect(Collectors.toList());
    }

    @Override
    public <T> T save(T entity) {
        this.maybeEmitEvent(entity, BeforeSaveEvent::new);
        this.dynamoDBMapper.save(entity);
        this.maybeEmitEvent(entity, AfterSaveEvent::new);
        return entity;
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchSave(Iterable<?> entities) {
        entities.forEach(it -> this.maybeEmitEvent(it, BeforeSaveEvent::new));
        List result = this.dynamoDBMapper.batchSave(entities);
        entities.forEach(it -> this.maybeEmitEvent(it, AfterSaveEvent::new));
        return result;
    }

    @Override
    public <T> T delete(T entity) {
        this.maybeEmitEvent(entity, BeforeDeleteEvent::new);
        this.dynamoDBMapper.delete(entity);
        this.maybeEmitEvent(entity, AfterDeleteEvent::new);
        return entity;
    }

    @Override
    public List<DynamoDBMapper.FailedBatch> batchDelete(Iterable<?> entities) {
        entities.forEach(it -> this.maybeEmitEvent(it, BeforeDeleteEvent::new));
        List result = this.dynamoDBMapper.batchDelete(entities);
        entities.forEach(it -> this.maybeEmitEvent(it, AfterDeleteEvent::new));
        return result;
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, QueryRequest queryRequest) {
        QueryResult queryResult = this.amazonDynamoDB.query(queryRequest);
        return new PaginatedQueryList(this.dynamoDBMapper, clazz, this.amazonDynamoDB, queryRequest, queryResult, this.dynamoDBMapperConfig.getPaginationLoadingStrategy(), this.dynamoDBMapperConfig);
    }

    @Override
    public <T> int count(Class<T> clazz, QueryRequest mutableQueryRequest) {
        mutableQueryRequest.setSelect(Select.COUNT);
        int count = 0;
        QueryResult queryResult = null;
        do {
            queryResult = this.amazonDynamoDB.query(mutableQueryRequest);
            count += queryResult.getCount().intValue();
            mutableQueryRequest.setExclusiveStartKey(queryResult.getLastEvaluatedKey());
        } while (queryResult.getLastEvaluatedKey() != null);
        return count;
    }

    @Override
    public <T> String getOverriddenTableName(Class<T> domainClass, String tableName) {
        if (this.dynamoDBMapperConfig.getTableNameOverride() != null) {
            tableName = this.dynamoDBMapperConfig.getTableNameOverride().getTableName() != null ? this.dynamoDBMapperConfig.getTableNameOverride().getTableName() : this.dynamoDBMapperConfig.getTableNameOverride().getTableNamePrefix() + tableName;
        } else if (this.dynamoDBMapperConfig.getTableNameResolver() != null) {
            tableName = this.dynamoDBMapperConfig.getTableNameResolver().getTableName(domainClass, this.dynamoDBMapperConfig);
        }
        return tableName;
    }

    @Override
    public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> domainClass) {
        return this.dynamoDBMapper.getTableModel(domainClass, this.dynamoDBMapperConfig);
    }

    protected <T> void maybeEmitEvent(@Nullable T source, Function<T, DynamoDBMappingEvent<T>> factory) {
        if (this.eventPublisher != null && source != null) {
            DynamoDBMappingEvent<T> event = factory.apply(source);
            this.eventPublisher.publishEvent(event);
        }
    }
}

