/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.proxy;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.subethamail.smtp.server.Session;

public interface ProxyHandler {
    public static final ProxyHandler NOP = (i, o, e) -> ProxyResult.NOP;

    public ProxyResult handle(InputStream var1, OutputStream var2, Session var3) throws IOException;

    public static final class ProxyResult {
        public static final ProxyResult NOP = new ProxyResult(null);
        public static final ProxyResult FAIL = new ProxyResult(503, "Required Proxy negotiation failed");
        private final boolean success;
        private final int errorCode;
        private final String errorMessage;
        private final InetSocketAddress proxiedAddress;

        public ProxyResult(InetSocketAddress proxiedAddress) {
            this.success = true;
            this.errorCode = 0;
            this.errorMessage = null;
            this.proxiedAddress = proxiedAddress;
        }

        public ProxyResult(int errorCode, String errorMessage) {
            Preconditions.checkArgument((errorCode > 399 && errorCode < 600 ? 1 : 0) != 0, (String)("Invalid SMTP response code " + errorCode));
            this.success = false;
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            this.proxiedAddress = null;
        }

        public InetSocketAddress getProxiedAddress() {
            return this.proxiedAddress;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isNOP() {
            return this.proxiedAddress == null;
        }

        public int errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }
    }
}

