/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.internal.io.CRLFTerminatedReader;
import org.subethamail.smtp.internal.proxy.ProxyHandler;
import org.subethamail.smtp.internal.server.ServerThread;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.SessionHandler;

public final class Session
implements Runnable,
MessageContext {
    private static final int BUFFER_SIZE = 8192;
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private final SMTPServer server;
    private final ServerThread serverThread;
    private final Map<String, String> parentLoggingMdcContext = MDC.getCopyOfContextMap();
    private String sessionId;
    private volatile boolean quitting = false;
    private Socket socket;
    private InputStream input;
    private CRLFTerminatedReader reader;
    private OutputStream output;
    private PrintWriter writer;
    private final ProxyHandler proxyHandler;
    private InetSocketAddress remoteAddress;
    private Optional<AuthenticationHandler> authenticationHandler = Optional.empty();
    private MessageHandler messageHandler;
    private Optional<String> helo = Optional.empty();
    private int recipientCount;
    private Optional<String> singleRecipient;
    private int declaredMessageSize = 0;
    private boolean tlsStarted;
    private Certificate[] tlsPeerCertificates;

    public Session(SMTPServer server, ServerThread serverThread, Socket socket, ProxyHandler proxyHandler) throws IOException {
        this.server = server;
        this.serverThread = serverThread;
        this.remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.setSocket(socket);
        this.tlsStarted = socket instanceof SSLSocket;
        this.proxyHandler = proxyHandler;
    }

    public SMTPServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block16: {
            if (this.parentLoggingMdcContext != null) {
                MDC.setContextMap(this.parentLoggingMdcContext);
            }
            this.sessionId = this.server.getSessionIdFactory().create();
            MDC.put((String)"SessionId", (String)this.sessionId);
            String originalName = Thread.currentThread().getName();
            Thread.currentThread().setName(Session.class.getName() + "-" + this.socket.getInetAddress() + ":" + this.socket.getPort());
            try {
                ProxyHandler.ProxyResult proxy = this.proxyHandler.handle(this.input, this.output, this);
                if (!proxy.isSuccess()) {
                    this.sendResponse(proxy.errorCode() + " " + proxy.errorMessage());
                    return;
                }
                if (!proxy.isNOP()) {
                    this.remoteAddress = proxy.getProxiedAddress();
                }
                if (log.isDebugEnabled()) {
                    InetAddress remoteInetAddress = this.getRemoteAddress().getAddress();
                    remoteInetAddress.getHostName();
                    log.debug("SMTP connection from {}, new connection count: {}", (Object)remoteInetAddress, (Object)this.serverThread.getNumberOfConnections());
                }
                this.runCommandLoop();
            }
            catch (IOException e1) {
                if (this.quitting) break block16;
                try {
                    this.sendResponse("421 4.4.0 Problem attempting to execute commands. Please try again later.");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                log.warn("Exception during SMTP transaction", (Throwable)e1);
            }
            catch (Throwable e) {
                log.error("Unexpected error in the SMTP handler thread", e);
                try {
                    this.sendResponse("421 4.3.0 Mail system failure, closing transmission channel");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Session.rethrow(e);
            }
            finally {
                this.closeConnection();
                this.endMessageHandler();
                this.serverThread.sessionEnded(this);
                Thread.currentThread().setName(originalName);
                MDC.clear();
            }
        }
    }

    private static void rethrow(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommandLoop() throws IOException {
        if (this.serverThread.hasTooManyConnections()) {
            log.debug("SMTP Too many connections!");
            this.sendResponse("421 Too many connections, try again later");
            return;
        }
        SessionHandler.SessionAcceptance sresult = this.server.getSessionHandler().accept(this);
        if (!sresult.accepted()) {
            log.debug("SMTP " + sresult.errorMessage());
            this.sendResponse(sresult.errorCode() + " " + sresult.errorMessage());
            return;
        }
        try {
            this.sendResponse("220 " + this.server.getHostName() + " ESMTP " + this.server.getSoftwareName());
            while (!this.quitting) {
                String line;
                block20: {
                    line = null;
                    try {
                        line = this.reader.readLine();
                    }
                    catch (SocketException ex) {
                        if (log.isDebugEnabled()) {
                            log.debug("Error reading client command: " + ex.getMessage(), (Throwable)ex);
                        }
                        this.server.getSessionHandler().onSessionEnd(this);
                        return;
                    }
                    if (line != null) break block20;
                    log.debug("no more lines from client");
                    return;
                }
                try {
                    log.debug("Client: {}", (Object)line);
                    this.server.getCommandHandler().handleCommand(this, line);
                }
                catch (DropConnectionException ex) {
                    this.sendResponse(ex.getErrorResponse());
                    return;
                }
                catch (SocketTimeoutException ex) {
                    this.sendResponse("421 Timeout waiting for data from client.");
                    return;
                }
                catch (CRLFTerminatedReader.TerminationException te) {
                    String msg = "501 Syntax error at character position " + te.position() + ". CR and LF must be CRLF paired.  See RFC 2821 #2.7.1.";
                    log.debug(msg);
                    this.sendResponse(msg);
                    return;
                }
                catch (CRLFTerminatedReader.MaxLineLengthException mlle) {
                    String msg = "501 " + mlle.getMessage();
                    log.debug(msg);
                    this.sendResponse(msg);
                    return;
                }
            }
        }
        finally {
            this.server.getSessionHandler().onSessionEnd(this);
        }
    }

    private void closeConnection() {
        try {
            try {
                this.writer.close();
                this.input.close();
            }
            finally {
                this.closeSocket();
            }
        }
        catch (IOException e) {
            log.info(e.toString());
        }
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.input = new BufferedInputStream(this.socket.getInputStream(), 8192);
        this.reader = new CRLFTerminatedReader(this.input);
        this.output = this.socket.getOutputStream();
        this.writer = new PrintWriter(this.output);
        this.socket.setSoTimeout(this.server.getConnectionTimeout());
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void closeSocket() throws IOException {
        if (this.socket != null && this.socket.isBound() && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public InputStream getRawInput() {
        return this.input;
    }

    public CRLFTerminatedReader getReader() {
        return this.reader;
    }

    public void sendResponse(String response) throws IOException {
        log.debug("Server: {}", (Object)response);
        this.writer.print(response + "\r\n");
        this.writer.flush();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public InetSocketAddress getRealRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SMTPServer getSMTPServer() {
        return this.server;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public Optional<String> getHelo() {
        return this.helo;
    }

    public void setHelo(String value) {
        this.helo = Optional.of(value);
    }

    public void addRecipient(String recipientAddress) {
        ++this.recipientCount;
        this.singleRecipient = this.recipientCount == 1 ? Optional.of(recipientAddress) : Optional.empty();
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public Optional<String> getSingleRecipient() {
        return this.singleRecipient;
    }

    public boolean isAuthenticated() {
        return this.authenticationHandler.isPresent();
    }

    @Override
    public Optional<AuthenticationHandler> getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler handler) {
        this.authenticationHandler = Optional.of(handler);
    }

    public int getDeclaredMessageSize() {
        return this.declaredMessageSize;
    }

    public void setDeclaredMessageSize(int declaredMessageSize) {
        this.declaredMessageSize = declaredMessageSize;
    }

    public void startMailTransaction() throws IllegalStateException {
        if (this.messageHandler != null) {
            throw new IllegalStateException("Mail transaction is already in progress");
        }
        this.messageHandler = this.server.getMessageHandlerFactory().create(this);
    }

    public boolean isMailTransactionInProgress() {
        return this.messageHandler != null;
    }

    public void resetMailTransaction() {
        this.endMessageHandler();
        this.messageHandler = null;
        this.recipientCount = 0;
        this.singleRecipient = Optional.empty();
        this.declaredMessageSize = 0;
    }

    private void endMessageHandler() {
        if (this.messageHandler != null) {
            try {
                this.messageHandler.done();
            }
            catch (Throwable ex) {
                log.error("done() threw exception", ex);
            }
        }
    }

    public void resetSmtpProtocol() {
        this.resetMailTransaction();
        this.helo = Optional.empty();
    }

    public void quit() {
        this.quitting = true;
        this.closeConnection();
    }

    public boolean isTLSStarted() {
        return this.tlsStarted;
    }

    public void setTlsStarted(boolean tlsStarted) {
        this.tlsStarted = tlsStarted;
    }

    public void setTlsPeerCertificates(Certificate[] tlsPeerCertificates) {
        this.tlsPeerCertificates = tlsPeerCertificates;
    }

    @Override
    public Certificate[] getTlsPeerCertificates() {
        return this.tlsPeerCertificates;
    }
}

