/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.BasicMessageListener;

public class BasicMessageHandlerFactory
implements MessageHandlerFactory {
    private final BasicMessageListener listener;
    private final int maxMessageSize;

    public BasicMessageHandlerFactory(BasicMessageListener listener, int maxMessageSize) {
        this.listener = listener;
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public MessageHandler create(MessageContext context) {
        return new BasicMessageHandler(context, this.listener, this.maxMessageSize);
    }

    public static class BasicMessageHandler
    implements MessageHandler {
        private final BasicMessageListener listener;
        private String from;
        private String recipient;
        private final MessageContext context;
        private final int maxMessageSize;

        public BasicMessageHandler(MessageContext context, BasicMessageListener listener, int maxMessageSize) {
            this.context = context;
            this.listener = listener;
            this.maxMessageSize = maxMessageSize;
        }

        @Override
        public void from(String from) throws RejectException {
            this.from = from;
        }

        @Override
        public void recipient(String recipient) throws RejectException {
            this.recipient = recipient;
        }

        @Override
        public String data(InputStream is) throws RejectException, TooMuchDataException, IOException {
            try {
                byte[] bytes = BasicMessageHandler.readAndClose(is, this.maxMessageSize);
                if (this.from == null) {
                    throw new RejectException("from not set");
                }
                if (this.recipient == null) {
                    throw new RejectException("recipient not set");
                }
                this.listener.messageArrived(this.context, this.from, this.recipient, bytes);
                return null;
            }
            catch (RuntimeException e) {
                throw new RejectException("message could not be accepted: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] readAndClose(InputStream is, int maxMessageSize) throws IOException, TooMuchDataException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            try {
                int n;
                while ((n = is.read(buffer)) != -1) {
                    bytes.write(buffer, 0, n);
                    if (maxMessageSize <= 0 || bytes.size() <= maxMessageSize) continue;
                    throw new TooMuchDataException("message size exceeded maximum of " + maxMessageSize + "bytes");
                }
            }
            finally {
                is.close();
            }
            return bytes.toByteArray();
        }

        @Override
        public void done() {
        }
    }
}

