/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.server;

import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.server.SessionHandler;

public final class ConcurrentSessionsBySourceLimiter
implements SessionHandler {
    private final SessionHandler.SessionAcceptance drop;
    private final int maxConnectionsPerSource;
    private final ConcurrentMap<InetAddress, Integer> counts;

    public ConcurrentSessionsBySourceLimiter(int maxConnectionsPerSource) {
        this(maxConnectionsPerSource, 421, "Too many connections, try again later");
    }

    public ConcurrentSessionsBySourceLimiter(int maxConnectionsPerSource, int code, String message) {
        this.maxConnectionsPerSource = maxConnectionsPerSource;
        this.drop = SessionHandler.SessionAcceptance.failure(code, message);
        this.counts = new ConcurrentHashMap<InetAddress, Integer>();
    }

    @Override
    public SessionHandler.SessionAcceptance accept(Session session) {
        try {
            this.counts.compute(ConcurrentSessionsBySourceLimiter.toInetAddress(session), (k, v) -> {
                if (v == null) {
                    return 1;
                }
                if (v == this.maxConnectionsPerSource) {
                    throw LimitReachedException.INSTANCE;
                }
                v = v + 1;
                return v;
            });
        }
        catch (LimitReachedException limit) {
            return this.drop;
        }
        return SessionHandler.SessionAcceptance.success();
    }

    @Override
    public void onSessionEnd(Session session) {
        this.counts.compute(ConcurrentSessionsBySourceLimiter.toInetAddress(session), (k, v) -> {
            if ((v = Integer.valueOf(v - 1)) == 0) {
                return null;
            }
            return v;
        });
    }

    private static InetAddress toInetAddress(Session session) {
        return session.getSocket().getInetAddress();
    }

    private static final class LimitReachedException
    extends RuntimeException {
        public static final LimitReachedException INSTANCE = new LimitReachedException();

        public LimitReachedException() {
            super("Limit reached", null, false, false);
        }
    }
}

