/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.server;

import java.io.IOException;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.internal.server.Command;
import org.subethamail.smtp.internal.server.CommandException;
import org.subethamail.smtp.internal.server.HelpMessage;
import org.subethamail.smtp.server.Session;

public final class RequireAuthCommandWrapper
implements Command {
    private final Command wrapped;

    public RequireAuthCommandWrapper(Command wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void execute(String commandString, Session sess) throws IOException, DropConnectionException {
        if (!sess.getServer().getRequireAuth() || sess.isAuthenticated()) {
            this.wrapped.execute(commandString, sess);
        } else {
            sess.sendResponse("530 5.7.0  Authentication required");
        }
    }

    @Override
    public HelpMessage getHelp() throws CommandException {
        return this.wrapped.getHelp();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }
}

