/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.io;

import java.io.IOException;
import java.io.InputStream;
import org.subethamail.smtp.internal.command.BdatCommand;
import org.subethamail.smtp.internal.io.CRLFTerminatedReader;
import org.subethamail.smtp.server.Session;

public final class BdatInputStream
extends InputStream {
    private final InputStream in;
    private final Session session;
    private final CRLFTerminatedReader reader;
    private long remainingSize;
    private long size;
    private boolean isLast;

    public BdatInputStream(InputStream in, Session session, long size, boolean isLast) {
        this.in = in;
        this.session = session;
        this.reader = new CRLFTerminatedReader(in);
        this.remainingSize = size;
        this.size = size;
        this.isLast = isLast;
    }

    @Override
    public int read() throws IOException {
        String line;
        while (true) {
            if (this.remainingSize > 0L) {
                int v = this.in.read();
                --this.remainingSize;
                return v;
            }
            if (this.isLast) {
                this.session.sendResponse("250 Message OK, " + this.size + " bytes received (last chunk)");
                return -1;
            }
            this.session.sendResponse("250 Message OK, " + this.size + " bytes received");
            line = this.reader.readLine();
            if (!line.startsWith("BDAT ")) break;
            BdatCommand.Bdat bdat = BdatCommand.parse(line);
            if (bdat.errorMessage != null) {
                this.session.sendResponse(bdat.errorMessage);
                throw new IOException(bdat.errorMessage);
            }
            this.remainingSize = bdat.size;
            this.size = bdat.size;
            this.isLast = bdat.isLast;
        }
        String message = "503 Error: expected BDAT command line but encountered: '" + line + "'";
        this.session.sendResponse(message);
        throw new IOException(message);
    }
}

