/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import com.github.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.functions.Action1;

public final class ConnectionProviderPooled
implements ConnectionProvider {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 30000;
    private final HikariDataSource pool;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);

    public ConnectionProviderPooled(String url, String username, String password, int minPoolSize, int maxPoolSize, long connectionTimeoutMs) {
        this(ConnectionProviderPooled.createPool(url, username, password, minPoolSize, maxPoolSize, connectionTimeoutMs));
    }

    ConnectionProviderPooled(HikariDataSource pool) {
        this.pool = pool;
    }

    public ConnectionProviderPooled(String url, String username, String password, int minPoolSize, int maxPoolSize) {
        this(ConnectionProviderPooled.createPool(url, username, password, minPoolSize, maxPoolSize, 30000L));
    }

    public ConnectionProviderPooled(String url, int minPoolSize, int maxPoolSize) {
        this(ConnectionProviderPooled.createPool(url, null, null, minPoolSize, maxPoolSize, 30000L));
    }

    public ConnectionProviderPooled(String url, String username, String password, int minSize, int maxSize, long connectionTimeoutMs, Action1<HikariDataSource> configureDataSource) {
        this(ConnectionProviderPooled.configure(ConnectionProviderPooled.createPool(url, username, password, minSize, maxSize, connectionTimeoutMs), configureDataSource));
    }

    private static HikariDataSource configure(HikariDataSource ds, Action1<HikariDataSource> configure) {
        if (configure != null) {
            configure.call((Object)ds);
        }
        return ds;
    }

    private static HikariDataSource createPool(String url, String username, String password, int minPoolSize, int maxPoolSize, long connectionTimeoutMs) {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(url);
        ds.setUsername(username);
        ds.setPassword(password);
        ds.setMinimumIdle(minPoolSize);
        ds.setMaximumPoolSize(maxPoolSize);
        ds.setConnectionTimeout(connectionTimeoutMs);
        return ds;
    }

    @Override
    public Connection get() {
        try {
            return this.pool.getConnection();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.isOpen.getAndSet(false)) {
            this.pool.close();
        }
    }
}

