/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.Iterator;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class ObservableReverse {
    private static final Func1<List<Object>, Observable<Object>> REVERSE_LIST = new Func1<List<Object>, Observable<Object>>(){

        public Observable<Object> call(List<Object> list) {
            return Observable.from((Iterable)ObservableReverse.reverse(list));
        }
    };

    public static <T> Observable<T> reverse(Observable<T> source) {
        return source.toList().flatMap(REVERSE_LIST);
    }

    private static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i;
                    {
                        this.i = list.size();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i > 0;
                    }

                    @Override
                    public T next() {
                        --this.i;
                        return list.get(this.i);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

