/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.ValidationException;
import com.github.danielflower.mavenplugins.release.VersionName;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.lib.Repository;

public class VersionNamer {
    @Parameter(property="delimiter")
    private String delimiter;

    public VersionNamer(String delimiter) {
        this.delimiter = delimiter;
    }

    public VersionNamer() {
        this(".");
    }

    public VersionName name(String pomVersion, Long buildNumber, Collection<Long> previousBuildNumbers) throws ValidationException {
        if (buildNumber == null) {
            buildNumber = previousBuildNumbers.size() == 0 ? Long.valueOf(0L) : Long.valueOf(VersionNamer.nextBuildNumber(previousBuildNumbers));
        }
        VersionName versionName = new VersionName(pomVersion, pomVersion.replace("-SNAPSHOT", ""), buildNumber, this.delimiter);
        if (!Repository.isValidRefName((String)("refs/tags/" + versionName.releaseVersion()))) {
            String summary = "Sorry, '" + versionName.releaseVersion() + "' is not a valid version.";
            throw new ValidationException(summary, Arrays.asList(summary, "Version numbers are used in the Git tag, and so can only contain characters that are valid in git tags.", "Please see https://www.kernel.org/pub/software/scm/git/docs/git-check-ref-format.html for tag naming rules."));
        }
        return versionName;
    }

    private static long nextBuildNumber(Collection<Long> previousBuildNumbers) {
        long max = 0L;
        for (Long buildNumber : previousBuildNumbers) {
            max = Math.max(max, buildNumber);
        }
        return max + 1L;
    }

    String getDelimiter() {
        return this.delimiter;
    }
}

