/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.embedded.Redis;
import redis.embedded.RedisServer;
import redis.embedded.RedisShardedCluster;
import redis.embedded.core.PortProvider;
import redis.embedded.core.RedisServerBuilder;
import redis.embedded.model.Shard;

public final class RedisShardedClusterBuilder {
    private static final Duration DEFAULT_INITIALIZATION_TIMEOUT = Duration.ofSeconds(20L);
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();
    private PortProvider shardPortProvider = PortProvider.newSequencePortProvider(6379);
    private Duration initializationTimeout = DEFAULT_INITIALIZATION_TIMEOUT;
    private final List<Shard> shards = new LinkedList<Shard>();
    private final Map<Integer, Set<Integer>> replicasPortsByMainNodePort = new LinkedHashMap<Integer, Set<Integer>>();

    public RedisShardedClusterBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisShardedClusterBuilder serverPorts(Collection<Integer> ports) {
        this.shardPortProvider = PortProvider.newPredefinedPortProvider(ports);
        return this;
    }

    public RedisShardedClusterBuilder initializationTimeout(Duration initializationTimeout) {
        this.initializationTimeout = initializationTimeout;
        return this;
    }

    public RedisShardedClusterBuilder ephemeralServers() {
        this.shardPortProvider = PortProvider.newEphemeralPortProviderInRedisClusterRange();
        return this;
    }

    public RedisShardedClusterBuilder ephemeral() {
        this.ephemeralServers();
        return this;
    }

    public RedisShardedClusterBuilder shard(String name, int replicaCount) {
        this.shards.add(new Shard(name, replicaCount, this.shardPortProvider));
        return this;
    }

    public RedisShardedCluster build() throws IOException {
        List<Redis> servers = this.buildServers();
        return new RedisShardedCluster(servers, this.replicasPortsByMainNodePort, this.initializationTimeout);
    }

    private List<Redis> buildServers() throws IOException {
        ArrayList<Redis> servers = new ArrayList<Redis>();
        for (Shard shard : this.shards) {
            servers.add(this.buildMainNode(shard));
            servers.addAll(this.buildReplicas(shard));
        }
        return servers;
    }

    private List<RedisServer> buildReplicas(Shard shard) throws IOException {
        ArrayList<RedisServer> replicas = new ArrayList<RedisServer>();
        Set<Integer> replicaPorts = this.replicasPortsByMainNodePort.get(shard.mainNodePort);
        for (Integer replicaPort : shard.replicaPorts) {
            replicaPorts.add(replicaPort);
            this.serverBuilder.reset();
            this.serverBuilder.port(replicaPort);
            this.serverBuilder.setting("cluster-enabled yes");
            this.serverBuilder.setting("cluster-config-file nodes-replica-" + replicaPort + ".conf");
            this.serverBuilder.setting("cluster-node-timeout 5000");
            this.serverBuilder.setting("appendonly no");
            RedisServer slave = this.serverBuilder.build();
            replicas.add(slave);
        }
        return replicas;
    }

    private RedisServer buildMainNode(Shard shard) throws IOException {
        this.replicasPortsByMainNodePort.put(shard.mainNodePort, new HashSet());
        this.serverBuilder.reset();
        this.serverBuilder.setting("cluster-enabled yes");
        this.serverBuilder.setting("cluster-config-file nodes-main-" + shard.mainNodePort + ".conf");
        this.serverBuilder.setting("cluster-node-timeout 5000");
        this.serverBuilder.setting("appendonly no");
        return this.serverBuilder.port(shard.mainNodePort).build();
    }
}

