/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import redis.embedded.model.OsArchitecture;
import redis.embedded.util.IO;
import redis.embedded.util.IOSupplier;

public interface ExecutableProvider {
    public static final String ENVIRONMENT_EXECUTABLE_LOCATION = "EMBEDDED_REDIS_EXECUTABLE";
    public static final String PROPERTY_EXECUTABLE_LOCATION = "embedded.redis.executable";
    public static final URI REDIS_7_2_MACOSX_14_SONOMA_HANKCP = URI.create("https://github.com/codemonstur/embedded-redis/raw/master/src/main/binaries/redis-server-7.2-darwin-arm64");

    public File get() throws IOException;

    public static ExecutableProvider newJarResourceProvider() {
        Map<OsArchitecture, String> map = ExecutableProvider.newProvidedVersionsMap();
        return ExecutableProvider.newJarResourceProvider(IO::newTempDirForBinary, map);
    }

    public static ExecutableProvider newJarResourceProvider(File tempDirectory) {
        Map<OsArchitecture, String> map = ExecutableProvider.newProvidedVersionsMap();
        return ExecutableProvider.newJarResourceProvider(() -> tempDirectory, map);
    }

    public static ExecutableProvider newJarResourceProvider(IOSupplier<File> tempDirectorySupplier) {
        Map<OsArchitecture, String> map = ExecutableProvider.newProvidedVersionsMap();
        return ExecutableProvider.newJarResourceProvider(tempDirectorySupplier, map);
    }

    public static ExecutableProvider newJarResourceProvider(Map<OsArchitecture, String> executables) {
        return ExecutableProvider.newJarResourceProvider(IO::newTempDirForBinary, executables);
    }

    public static ExecutableProvider newJarResourceProvider(IOSupplier<File> tempDirectory, Map<OsArchitecture, String> executables) {
        OsArchitecture osArch = OsArchitecture.detectOSandArchitecture();
        return () -> IO.writeResourceToExecutableFile((File)tempDirectory.get(), (String)executables.get(osArch));
    }

    public static ExecutableProvider newFileThenJarResourceProvider(Map<OsArchitecture, String> executables) {
        return () -> {
            String executablePath = (String)executables.get(OsArchitecture.detectOSandArchitecture());
            File executable = new File(executablePath);
            File tempDir = IO.newTempDirForBinary();
            return executable.isFile() ? executable : IO.writeResourceToExecutableFile(tempDir, executablePath);
        };
    }

    public static ExecutableProvider newEnvironmentVariableProvider() {
        return ExecutableProvider.newEnvironmentVariableProvider(ENVIRONMENT_EXECUTABLE_LOCATION);
    }

    public static ExecutableProvider newEnvironmentVariableProvider(String envName) {
        return () -> new File(System.getenv(envName));
    }

    public static ExecutableProvider newSystemPropertyProvider() {
        return ExecutableProvider.newSystemPropertyProvider(PROPERTY_EXECUTABLE_LOCATION);
    }

    public static ExecutableProvider newSystemPropertyProvider(String propertyName) {
        return () -> new File(System.getProperty(propertyName));
    }

    public static ExecutableProvider newExecutableInPath(String executableName) throws FileNotFoundException {
        return IO.findBinaryInPath(executableName)::toFile;
    }

    public static ExecutableProvider newCachedUrlProvider(Path cachedLocation, URI uri) {
        return () -> {
            if (Files.isRegularFile(cachedLocation, new LinkOption[0])) {
                return cachedLocation.toFile();
            }
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            try {
                if (connection.getResponseCode() != 200) {
                    throw new IOException("Failed to download redis binary from " + uri + ", status code is " + connection.getResponseCode());
                }
                Files.createDirectories(cachedLocation.getParent(), new FileAttribute[0]);
                try (OutputStream out = Files.newOutputStream(cachedLocation, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                     InputStream in = connection.getInputStream();){
                    int length;
                    byte[] buffer = new byte[8192];
                    while ((length = in.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                }
                cachedLocation.toFile().setExecutable(true);
                File file = cachedLocation.toFile();
                return file;
            }
            finally {
                connection.disconnect();
            }
        };
    }

    public static Map<OsArchitecture, String> newProvidedVersionsMap() {
        HashMap<OsArchitecture, String> map = new HashMap<OsArchitecture, String>();
        map.put(OsArchitecture.UNIX_x86, "/redis-server-6.2.7-linux-386");
        map.put(OsArchitecture.UNIX_x86_64, "/redis-server-6.2.6-v5-linux-amd64");
        map.put(OsArchitecture.UNIX_AARCH64, "/redis-server-6.2.7-linux-arm64");
        map.put(OsArchitecture.WINDOWS_x86_64, "/redis-server-5.0.14.1-windows-amd64.exe");
        map.put(OsArchitecture.MAC_OS_X_x86_64, "/redis-server-6.2.6-v5-darwin-amd64");
        map.put(OsArchitecture.MAC_OS_X_ARM64, "/redis-server-6.2.6-v5-darwin-arm64");
        return map;
    }
}

