/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.telemetry;

import com.github.cameltooling.lsp.internal.telemetry.InitializationTelemetryInfo;
import com.github.cameltooling.lsp.internal.telemetry.TelemetryEvent;
import java.util.Collections;
import java.util.Map;
import org.eclipse.lsp4j.services.LanguageClient;

public class TelemetryManager {
    public static final String STARTUP_EVENT_NAME = "camel.lsp.server.initialized";
    public static final String OPENED_DOCUMENT = "camel.lsp.open.document";
    private final LanguageClient languageClient;

    public TelemetryManager(LanguageClient languageClient) {
        this.languageClient = languageClient;
    }

    public void onInitialized() {
        this.telemetryEvent(STARTUP_EVENT_NAME, InitializationTelemetryInfo.getInitializationTelemetryInfo());
    }

    private void telemetryEvent(String eventName, Map<String, Object> object) {
        this.languageClient.telemetryEvent((Object)new TelemetryEvent(eventName, object));
    }

    public void sendOpenedCamelFile(String uri) {
        int lastIndexOfDot = uri.lastIndexOf(46);
        String extension = lastIndexOfDot != -1 ? uri.substring(lastIndexOfDot + 1) : uri;
        this.telemetryEvent(OPENED_DOCUMENT, Collections.singletonMap("language", extension));
    }
}

