/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.telemetry;

import com.github.cameltooling.lsp.internal.telemetry.JVM;
import com.github.cameltooling.lsp.internal.telemetry.OS;

public class Platform {
    private static final String UNKNOWN_VALUE = "unknown";
    private static final OS os = new OS();
    private static final JVM jvm = new JVM();

    private Platform() {
    }

    public static OS getOS() {
        return os;
    }

    public static JVM getJVM() {
        return jvm;
    }

    static String getSystemProperty(String key) {
        try {
            String property = System.getProperty(key);
            return property == null || property.isEmpty() ? UNKNOWN_VALUE : property;
        }
        catch (SecurityException e) {
            return UNKNOWN_VALUE;
        }
    }

    public static String details() {
        StringBuilder details = new StringBuilder();
        Platform.append(details, "Java", jvm.getJavaHome());
        Platform.append(details, "VM Version", jvm.getVersion());
        return details.toString();
    }

    private static void append(StringBuilder sb, String key, String value) {
        sb.append(System.lineSeparator()).append(" - ").append(key);
        if (value != null) {
            sb.append(" : ").append(value);
        }
    }
}

