/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.parser;

import com.github.cameltooling.lsp.internal.parser.ParserFileHelper;
import com.github.cameltooling.lsp.internal.parser.ParserXMLFileHelper;
import com.github.cameltooling.lsp.internal.parser.fileparserhelper.ParserChainOfResponsibility;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.lsp4j.TextDocumentItem;
import org.xml.sax.SAXException;

public class ParserFileHelperFactory {
    private static final String KUBERNETES_CRD_API_VERSION_CAMEL = "apiVersion: camel.apache.org/";
    private static final String CAMELK_XML_FILENAME_SUFFIX = "camelk.xml";
    private static final String CAMELK_YAML_FILENAME_SUFFIX = ".camelk.yaml";
    private static final String PLAIN_CAMEL_YAML_FILENAME_SUFFIX = ".camel.yaml";
    private static final String CAMELK_YML_FILENAME_SUFFIX = ".camelk.yml";
    private static final String PLAIN_CAMEL_YML_FILENAME_SUFFIX = ".camel.yml";
    private static final String SHEBANG_CAMEL_K = "#!/usr/bin/env camel-k";

    public ParserFileHelper getCorrespondingParserFileHelper(TextDocumentItem textDocumentItem, int line) {
        return ParserChainOfResponsibility.getMatchedParserFileHelper(textDocumentItem, line, this);
    }

    public boolean isProbablyCamelFile(TextDocumentItem textDocumentItem) {
        String uri = textDocumentItem.getUri();
        return this.isHighProbabilityCamelJavaDSL(textDocumentItem, uri) || this.isCamelXMLDSL(textDocumentItem, uri) || this.isCamelYamlDSL(textDocumentItem, uri);
    }

    private boolean isCamelXMLDSL(TextDocumentItem textDocumentItem, String uri) {
        try {
            return uri.endsWith(CAMELK_XML_FILENAME_SUFFIX) || uri.endsWith(".xml") && new ParserXMLFileHelper().hasElementFromCamelNamespace(textDocumentItem);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
    }

    public boolean isCamelYamlDSL(TextDocumentItem textDocumentItem, String uri) {
        return uri.endsWith(CAMELK_YAML_FILENAME_SUFFIX) || uri.endsWith(CAMELK_YML_FILENAME_SUFFIX) || uri.endsWith(PLAIN_CAMEL_YAML_FILENAME_SUFFIX) || uri.endsWith(PLAIN_CAMEL_YML_FILENAME_SUFFIX) || this.isYamlFileWithCamelKShebang(textDocumentItem, uri) || this.isYamlFileWithCamelKModelineLike(textDocumentItem, uri) || this.isYamlFileOfCRDType(textDocumentItem, uri);
    }

    private boolean isYamlFileOfCRDType(TextDocumentItem textDocumentItem, String uri) {
        return this.hasYamlExtension(uri) && textDocumentItem.getText().startsWith(KUBERNETES_CRD_API_VERSION_CAMEL);
    }

    private boolean hasYamlExtension(String uri) {
        return uri.endsWith(".yaml") || uri.endsWith(".yml");
    }

    private boolean isYamlFileWithCamelKModelineLike(TextDocumentItem textDocumentItem, String uri) {
        return this.hasYamlExtension(uri) && textDocumentItem.getText().startsWith("# camel-k:");
    }

    protected boolean isYamlFileWithCamelKShebang(TextDocumentItem textDocumentItem, String uri) {
        return this.hasYamlExtension(uri) && textDocumentItem.getText().startsWith(SHEBANG_CAMEL_K);
    }

    public boolean isPotentiallyCamelJavaDSL(TextDocumentItem textDocumentItem, String uri) {
        return uri.endsWith(".java") && textDocumentItem.getText().contains("camel");
    }

    private boolean isHighProbabilityCamelJavaDSL(TextDocumentItem textDocumentItem, String uri) {
        String text = textDocumentItem.getText();
        return this.isPotentiallyCamelJavaDSL(textDocumentItem, uri) && text.contains("from(") && text.contains(".to");
    }
}

