/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.parser;

import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.YamlDSLModelHelper;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelper;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class CamelYamlDSLParser
extends ParserFileHelper {
    public static final String URI_KEY = "uri";
    public static final String REST_KEY = "rest";
    public static final String FROM_KEY = "from";
    public static final String TO_KEY = "to";

    @Override
    public String getCamelComponentUri(String line, int characterPosition) {
        String camelComponentURI = null;
        Map<?, ?> data = this.parseYaml(line);
        if (data != null && data.containsKey(URI_KEY) && URI_KEY.length() < characterPosition) {
            camelComponentURI = this.getNonNullValue(data.get(URI_KEY));
        } else if (data != null && data.containsKey(TO_KEY) && data.get(TO_KEY).toString().trim().length() > 0) {
            camelComponentURI = this.getNonNullValue(data.get(TO_KEY));
        }
        return camelComponentURI;
    }

    @Override
    public CamelURIInstance createCamelURIInstance(TextDocumentItem textDocumentItem, Position position, String camelComponentUri) {
        String line = this.parserFileHelperUtil.getLine(textDocumentItem, position.getLine());
        String stringEncloser = this.getStringEncloser(line);
        CamelURIInstance uriInstance = new CamelURIInstance(this.repairLostEscapeChars(stringEncloser, camelComponentUri), new YamlDSLModelHelper(this.getCorrespondingType(textDocumentItem, position.getLine())), textDocumentItem);
        int start = this.getStartCharacterInDocumentOnLinePosition(textDocumentItem, position);
        uriInstance.setStartPositionInDocument(new Position(position.getLine(), start));
        uriInstance.setEndPositionInDocument(new Position(position.getLine(), start + this.repairLostEscapeChars(stringEncloser, camelComponentUri).length()));
        return uriInstance;
    }

    private String getNonNullValue(Object o) {
        if (o != null) {
            return o.toString();
        }
        return "";
    }

    private int getStartCharacterInDocumentOnLinePosition(TextDocumentItem textDocumentItem, Position position) {
        String line = this.parserFileHelperUtil.getLine(textDocumentItem, position.getLine());
        String stringEncloser = this.getStringEncloser(line);
        String uri = this.extractUriFromYamlData(line);
        if (uri == null || uri.isEmpty()) {
            return this.findStartPositionOfURI(line);
        }
        uri = this.repairLostEscapeChars(stringEncloser, uri);
        return line.indexOf(uri);
    }

    @Override
    public int getPositionInCamelURI(TextDocumentItem textDocumentItem, Position position) {
        String line = this.parserFileHelperUtil.getLine(textDocumentItem, position.getLine());
        return position.getCharacter() - this.findStartPositionOfURI(line);
    }

    private String getStringEncloser(String line) {
        String stringEncloser;
        int idx = this.determineQuoteStartPos(line, line.indexOf(58));
        if (idx != -1 && ((stringEncloser = String.valueOf(line.charAt(idx))).equals("\"") || stringEncloser.equals("'"))) {
            return stringEncloser;
        }
        return null;
    }

    String repairLostEscapeChars(String stringEncloser, String line) {
        if (stringEncloser == null) {
            return line;
        }
        if (line == null) {
            return "";
        }
        String[] parts = line.split(stringEncloser);
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                if ("\"".equals(stringEncloser)) {
                    res.append(String.format("\\%s", stringEncloser));
                } else {
                    res.append(String.format("%s%s", stringEncloser, stringEncloser));
                }
            }
            res.append(parts[i]);
        }
        return res.toString();
    }

    private int findStartPositionOfURI(String line) {
        int start;
        int separatorPos = line.indexOf(58) + 1;
        if (this.isStartOfUri(separatorPos, start = this.determineQuoteStartPos(line, separatorPos), line)) {
            return start + 1;
        }
        int spaceCnt = 0;
        for (int i = separatorPos; i < line.length() && line.charAt(i) == ' '; ++i) {
            ++spaceCnt;
        }
        return separatorPos + spaceCnt;
    }

    private int determineQuoteStartPos(String line, int separatorPos) {
        int singleQuotePos = line.indexOf(39, separatorPos);
        int doubleQuotePos = line.indexOf(34, separatorPos);
        int startPos = -1;
        if (singleQuotePos == -1) {
            if (doubleQuotePos != -1) {
                startPos = doubleQuotePos;
            }
        } else {
            startPos = doubleQuotePos == -1 ? singleQuotePos : Math.min(singleQuotePos, doubleQuotePos);
        }
        if (startPos != -1 && startPos > separatorPos) {
            for (int i = startPos; i > separatorPos; --i) {
                if (line.charAt(i) == '\"' || line.charAt(i) == '\'' || line.charAt(i) == ' ') continue;
                return -1;
            }
        }
        return startPos;
    }

    private boolean isStartOfUri(int separatorPos, int pos, String line) {
        if (pos == -1) {
            return false;
        }
        for (int i = pos - 1; i > separatorPos; --i) {
            if (line.charAt(i) == ' ' || line.charAt(i) == ':') continue;
            return false;
        }
        return true;
    }

    public String getCorrespondingType(TextDocumentItem textDocumentItem, int lineNumber) {
        for (int lineNo = lineNumber; lineNo >= 0; --lineNo) {
            String tempLine = this.parserFileHelperUtil.getLine(textDocumentItem, lineNo);
            Map<?, ?> data = this.parseYaml(tempLine);
            if (data == null) continue;
            if (data.containsKey(TO_KEY)) {
                return TO_KEY;
            }
            if (data.containsKey(FROM_KEY)) {
                return FROM_KEY;
            }
            if (!data.containsKey(REST_KEY)) continue;
            return null;
        }
        return null;
    }

    private Map<?, ?> parseYaml(String line) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Object obj = yaml.load(line);
        return this.extractMapFromYaml(obj);
    }

    private String extractUriFromYamlData(String line) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Object obj = yaml.load(line);
        Map<?, ?> m = this.extractMapFromYaml(obj);
        if (m != null && !m.values().isEmpty()) {
            return this.getNonNullValue(m.values().toArray()[0]);
        }
        return null;
    }

    private Map<?, ?> extractMapFromYaml(Object o) {
        if (o instanceof List) {
            List l = (List)o;
            if (!l.isEmpty() && l.get(0) instanceof Map) {
                return (Map)l.get(0);
            }
        } else if (o instanceof Map) {
            return (Map)o;
        }
        return null;
    }
}

