/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.parser;

import com.github.cameltooling.lsp.internal.completion.modeline.CamelKModelineFileType;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelKModelineInsertionParser {
    private final TextDocumentItem document;

    public CamelKModelineInsertionParser(TextDocumentItem document) {
        this.document = document;
    }

    public boolean canPutCamelKModeline(Position position) {
        int currentLine = position.getLine();
        return this.retrieveFileType().map(fileType -> this.lineIsEmpty(currentLine) && this.noModelineInsertedAlready((CamelKModelineFileType)((Object)fileType)) && this.previousLinesAreCommentsOrEmpty(currentLine, (CamelKModelineFileType)((Object)fileType))).orElse(false);
    }

    private Optional<CamelKModelineFileType> retrieveFileType() {
        return CamelKModelineFileType.getFileTypeCorrespondingToUri(this.document.getUri());
    }

    private boolean lineIsEmpty(int line) {
        return new ParserFileHelperUtil().getLine(this.document, line).isBlank();
    }

    private boolean noModelineInsertedAlready(CamelKModelineFileType forFileType) {
        String modeline = forFileType.getModeline();
        return Arrays.stream(this.document.getText().split("\n")).noneMatch(line -> line.startsWith(modeline));
    }

    private boolean previousLinesAreCommentsOrEmpty(int line, CamelKModelineFileType forFileType) {
        String textBeforeLine = IntStream.range(0, line).boxed().map(currLine -> new ParserFileHelperUtil().getLine(this.document, (int)currLine)).collect(Collectors.joining("\n"));
        return this.textIsFullOfRegex(textBeforeLine, forFileType.getCommentRegexSupplier().get());
    }

    private boolean textIsFullOfRegex(String text, Pattern regex) {
        String textWithExtraCarriageReturn = text + "\n";
        String textWithoutComments = textWithExtraCarriageReturn.replaceAll(regex.pattern(), "");
        return textWithoutComments.isBlank();
    }
}

