/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyEntryInstance;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelinePropertyFileOption;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelKModelinePropertyOption
implements ICamelKModelineOptionValue {
    private static final String FILE_PREFIX = "file:";
    private CamelPropertyEntryInstance singlePropertyValue;
    private CamelKModelinePropertyFileOption fileValue;
    private int startPosition;
    private String fullStringValue;
    private int line;

    public CamelKModelinePropertyOption(String value, int startPosition, TextDocumentItem documentItem, int line) {
        this.line = line;
        if (value.startsWith(FILE_PREFIX)) {
            this.fileValue = new CamelKModelinePropertyFileOption(value.substring(FILE_PREFIX.length()), startPosition + FILE_PREFIX.length(), documentItem.getUri(), line);
        } else {
            this.singlePropertyValue = new CamelPropertyEntryInstance(value, new Position(0, startPosition), documentItem);
        }
        this.fullStringValue = value;
        this.startPosition = startPosition;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.startPosition + this.fullStringValue.length();
    }

    @Override
    public String getValueAsString() {
        return this.fullStringValue;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int positionInLine, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.fileValue != null && this.fileValue.isInRange(positionInLine)) {
            return this.fileValue.getCompletions(positionInLine, camelCatalog);
        }
        if (this.singlePropertyValue != null) {
            CompletableFuture<List<CompletionItem>> camelComponentPropertyCompletionFuture = this.singlePropertyValue.getCompletions(new Position(0, positionInLine), camelCatalog, null, null);
            if (positionInLine == this.getStartPositionInLine()) {
                return this.mergeFutures(camelComponentPropertyCompletionFuture, this.createFilePrefixCompletion());
            }
            return camelComponentPropertyCompletionFuture;
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private CompletableFuture<List<CompletionItem>> createFilePrefixCompletion() {
        CompletionItem filePrefixCompletionItem = new CompletionItem(FILE_PREFIX);
        filePrefixCompletionItem.setDocumentation("Provide a properties file path");
        return CompletableFuture.completedFuture(Collections.singletonList(filePrefixCompletionItem));
    }

    private CompletableFuture<List<CompletionItem>> mergeFutures(CompletableFuture<List<CompletionItem>> future1, CompletableFuture<List<CompletionItem>> future2) {
        List<CompletableFuture> allFutures = Arrays.asList(future1, future2);
        return CompletableFuture.allOf(future1, future2).thenApply(avoid -> allFutures.stream().flatMap(f -> ((List)f.join()).stream()).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Hover> getHover(int characterPosition, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.singlePropertyValue != null) {
            return this.singlePropertyValue.getHover(new Position(0, characterPosition), camelCatalog, null);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getLine() {
        return this.line;
    }
}

