/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.completion.modeline.CamelKModelineOptionNames;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineConfigOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineDependencyOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineOpenAPIOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelinePropertyDashFileOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelinePropertyOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineResourceOption;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import com.github.cameltooling.lsp.internal.modelinemodel.GenericCamelKModelineOptionValue;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CamelKModelineOption
implements ILineRangeDefineable {
    private static final String END_OF_XML_COMMENT = "-->";
    private String optionName;
    private ICamelKModelineOptionValue optionValue;
    private int startCharacter;
    private int line;

    public CamelKModelineOption(String option, int startCharacter, TextDocumentItem documentItem, int line) {
        this.line = line;
        int nameValueIndexSeparator = option.indexOf(61);
        this.startCharacter = startCharacter;
        this.optionName = option.substring(0, nameValueIndexSeparator != -1 ? nameValueIndexSeparator : option.length());
        this.optionValue = this.createOptionValue(option, nameValueIndexSeparator, documentItem);
    }

    private ICamelKModelineOptionValue createOptionValue(String option, int nameValueIndexSeparator, TextDocumentItem documentItem) {
        if (nameValueIndexSeparator != -1) {
            String value = option.substring(nameValueIndexSeparator + 1);
            if (this.isEndOfCommentStuckToEndLine(option, documentItem, value)) {
                value = value.substring(0, value.length() - END_OF_XML_COMMENT.length());
            }
            int startPosition = this.getStartPositionInLine() + this.optionName.length() + 1;
            if ("trait".equals(this.optionName)) {
                return new CamelKModelineTraitOption(value, startPosition, this.line);
            }
            if ("dependency".equals(this.optionName)) {
                return new CamelKModelineDependencyOption(value, startPosition, this.line);
            }
            if ("property".equals(this.optionName)) {
                return new CamelKModelinePropertyOption(value, startPosition, documentItem, this.line);
            }
            if ("property-file".equals(this.optionName)) {
                return new CamelKModelinePropertyDashFileOption(value, startPosition, documentItem.getUri(), this.line);
            }
            if ("resource".equals(this.optionName)) {
                return new CamelKModelineResourceOption(value, startPosition, documentItem.getUri(), this.line);
            }
            if ("open-api".equals(this.optionName)) {
                return new CamelKModelineOpenAPIOption(value, startPosition, documentItem.getUri(), this.line);
            }
            if ("config".equals(this.optionName)) {
                return new CamelKModelineConfigOption(value, startPosition, documentItem.getUri(), this.line);
            }
            return new GenericCamelKModelineOptionValue(value, startPosition, this.line);
        }
        return null;
    }

    private boolean isEndOfCommentStuckToEndLine(String option, TextDocumentItem documentItem, String value) {
        return value.endsWith(END_OF_XML_COMMENT) && documentItem.getUri().endsWith(".xml") && this.startCharacter + option.length() == new ParserFileHelperUtil().getLine(documentItem, this.getLine()).length();
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startCharacter;
    }

    @Override
    public int getEndPositionInLine() {
        if (this.optionValue != null) {
            return this.optionValue.getEndPositionInLine();
        }
        return this.startCharacter + this.optionName.length();
    }

    public String getOptionName() {
        return this.optionName;
    }

    public ICamelKModelineOptionValue getOptionValue() {
        return this.optionValue;
    }

    public boolean isInRange(int positionInLine) {
        return this.getStartPositionInLine() <= positionInLine && this.getEndPositionInLine() >= positionInLine;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.optionValue != null && this.optionValue.isInRange(position)) {
            return this.optionValue.getCompletions(position, camelCatalog);
        }
        String filter = this.optionName.substring(0, position - this.getStartPositionInLine());
        return CompletableFuture.completedFuture(CamelKModelineOptionNames.getCompletionItems(filter));
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        String description;
        if (this.getStartPositionInLine() <= position.getCharacter() && position.getCharacter() <= this.getStartPositionInLine() + this.optionName.length() && (description = CamelKModelineOptionNames.getDescription(this.optionName)) != null) {
            Hover hover = new Hover();
            hover.setContents(Collections.singletonList(Either.forLeft((Object)description)));
            hover.setRange(new Range(new Position(this.getLine(), this.getStartPositionInLine()), new Position(this.getLine(), this.getStartPositionInLine() + this.optionName.length())));
            return CompletableFuture.completedFuture(hover);
        }
        if (this.optionValue != null && this.optionValue.isInRange(position.getCharacter())) {
            return this.optionValue.getHover(position.getCharacter(), camelCatalog);
        }
        return CompletableFuture.completedFuture(null);
    }
}

